% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imu.R
\name{autoplot.auto.imu}
\alias{autoplot.auto.imu}
\title{Automatic Model Selection Results of IMU Object}
\usage{
\method{autoplot}{auto.imu}(object, CI = TRUE, background = "white",
  transparence = 0.1, line.color = NULL, line.type = NULL,
  point.size = NULL, point.shape = NULL, CI.color = "#003C7D",
  title = "Automatic Model Selection Results", title.size = 15,
  axis.label.size = 13, axis.tick.size = 11,
  axis.x.label = expression(paste("Scale ", tau)),
  axis.y.label = expression(paste("Wavelet Variance ", nu)),
  facet.label.size = 13, facet.label.background = "#003C7D33",
  scales = "free_y", ...)
}
\arguments{
\item{object}{A \code{auto.imu} object}

\item{CI}{A \code{boolean} that indicates whether the confidence interval should be plotted.}

\item{background}{A \code{string} that determines the graph background. It can be \code{'grey'} or \code{'white'}.}

\item{transparence}{A \code{double} that ranges from 0 to 1 that controls the transparency of the confidence interval.}

\item{line.color}{A \code{vector} of \code{string} that indicates the color of the line drawn (e.g. black, blue, red, etc.)}

\item{line.type}{A \code{vector} of \code{string} that indicates the type of line (e.g. solid, dotted, etc.)}

\item{point.size}{A \code{vector} of \code{integer} that indicates the size of points on lines.}

\item{point.shape}{A \code{vector} of \code{integer} that indicates the shape of points on lines.}

\item{CI.color}{A \code{string} that indicates the color of the confidence interval (e.g. black, red, #003C7D, etc.)}

\item{title}{A \code{string} that indicates the title of the graph.}

\item{title.size}{An \code{integer} that indicates the size of title.}

\item{axis.label.size}{An \code{integer} that indicates the size of label.}

\item{axis.tick.size}{An \code{integer} that indicates the size of tick mark.}

\item{axis.x.label}{A \code{string} that indicates the label on x axis.}

\item{axis.y.label}{A \code{string} that indicates the label on y axis.}

\item{facet.label.size}{An \code{integer} that indicates the size of facet label.}

\item{facet.label.background}{A \code{string} that indicates the background color of the facet label.}

\item{scales}{Same as \code{scales} in \code{facet_grid()} in \code{ggplot2} package: should scales be fixed ("fixed"), free ("free"), or free in one dimension ("free_x", "free_y"). The default is "free_y" in this function.}

\item{...}{Additional options.}
}
\value{
A panel containing the automatic model selection results of an IMU sensor.
}
\description{
Creates a graph of the automatic model selection result containing the empirical and theoretical wavelet variances.
}
\examples{
\dontrun{
if(!require("imudata")){
   install_imudata()
   library("imudata")
}

data(imu6)
test = imu(imu6, gyroscope = 1:3, accelerometer = 4:6, axis = c('X', 'Y', 'Z'))
df = auto.imu(test)
autoplot(df)
autoplot(df, CI = F)
autoplot(df, CI = T, line.color = c('black', 'black', 'blue'), title.size = 18)
}
}
\keyword{internal}

