% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gts.R
\name{gts}
\alias{gts}
\title{Create a GMWM TS Object based on data}
\usage{
gts(data, start = 0, end = NULL, freq = 1, unit = NULL, name = NULL)
}
\arguments{
\item{data}{A one-column \code{matrix}, \code{data.frame}, or a numeric \code{vector}.}

\item{start}{A \code{numeric} that provides the time of the first observation.}

\item{end}{A \code{numeric} that provides the time of the last observation.}

\item{freq}{A \code{numeric} that provides the rate of samples. Default value is 1.}

\item{unit}{A \code{string} that contains the unit expression of the frequency. Default value is \code{NULL}.}

\item{name}{A \code{string} that provides an identifier to the data. Default value is \code{NULL}.}
}
\value{
A \code{gts} object with the following attributes:
\describe{
  \item{start}{The time of the first observation}
  \item{end}{The time of the last observation}
  \item{freq}{Numeric representation of frequency}
  \item{unit}{String representation of the unit}
  \item{name}{Name of the dataset}
}
}
\description{
Setups a time series oriented object that works well with graphing and summary utilities
}
\examples{
m = data.frame(rnorm(50))
x = gts(m, unit = 'sec', name = 'example')
x
plot(x)

x = gen.gts(WN(sigma2=1), 50)
x = gts(x, freq = 100, unit = 'sec')
plot(x)
}
\author{
JJB, Wenchao
}

