% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imu.R
\name{read.imu}
\alias{read.imu}
\title{Read an IMU Binary File into R}
\usage{
read.imu(file, type, unit = NULL, name = NULL)
}
\arguments{
\item{file}{A \code{string} containing file names or paths.}

\item{type}{A \code{string} that contains a supported IMU type given below.}

\item{unit}{A \code{string} that contains the unit expression of the frequency. Default value is \code{NULL}.}

\item{name}{A \code{string} that provides an identifier to the data. Default value is \code{NULL}.}
}
\value{
An \code{imu} object that contains 3 gyroscopes and 3 accelerometers in that order.
}
\description{
Process binary files within the
}
\details{
Currently supports the following IMUs:
\itemize{
\item IMAR
\item LN200
\item LN200IG
\item IXSEA
\item NAVCHIP_INT
\item NAVCHIP_FLT
}

We hope to soon be able to support delimited files.
}
\examples{
\dontrun{
# Relative
setwd("F:/")

a = read.imu(file = "Documents/James/short_test_data.imu", type = "IXSEA")

# Fixed path
b = read.imu(file = "F:/Desktop/short_test_data.imu", type = "IXSEA")
}
}
\references{
Thanks goes to Philipp Clausen of Labo TOPO, EPFL, Switzerland, topo.epfl.ch, Tel:+41(0)21 693 27 55
for providing a matlab function that reads in IMUs.
This function is a heavily modified port of MATLAB code into Armadillo/C++.
}

