% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Variance_multiple_parameter_estimation.R
\name{alpha.multi.est}
\alias{alpha.multi.est}
\title{Variance parameters}
\usage{
alpha.multi.est(
  qt,
  x,
  iter_num = 50,
  eps_param = 1e-10,
  initial_guess = rep(0, ncol(x))
)
}
\arguments{
\item{qt}{A numeric vector.}

\item{x}{A numeric matrix, each column represents a covariate.}

\item{iter_num}{An integer. Represents the number of iterations performed in the Gauss-Newton algorithm}

\item{eps_param}{A number. The Gauss-Newton algorithm terminates if the incriment change of all variance estimates is smaller than this number.}

\item{initial_guess}{A vector of length ncol(x). Represents the initial guess of parameters for the Gauss-Newton algorithm.}
}
\value{
A vector with a variance estimate for each variable.
}
\description{
This function jointly estimates the variance effect of a set of (continuous) variables on a qt trait.
More precisely. It finds the maximum likelyhood estimators.
}
\examples{
n_val <- 50000
x <- matrix(0,nrow = n_val, ncol = 4)
for(i in 1:4) {
x[, i] <- rnorm(n_val)
}
var_vec <- exp(0.2 * x[, 1] - 0.3 * x[, 4])
qt_vec <- rnorm(n_val, 0, sqrt(var_vec))
res <- alpha.multi.est(qt_vec, x)
}
