% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_genesets_syngo.R
\name{load_genesets_syngo}
\alias{load_genesets_syngo}
\title{parse genesets from the SynGO database}
\usage{
load_genesets_syngo(filename, gene_database = "entrez")
}
\arguments{
\item{filename}{full path to the "syngo_ontologies.xlsx" file that was extracted from a SynGO bulk download ZIP archive}

\item{gene_database}{gene IDs to return. must be any of; "entrez" (default), "hgnc", "ensembl"}
}
\value{
table with columns; source (character), source_version (character), id (character), name (character), genes (list), ngenes (int)
}
\description{
Workflow;
\itemize{
\item obtain the input file from; https://www.syngoportal.org
\item click "bulk download SynGO release ..." for SynGO release of interest
\item unzip
\item call this function with the full file path to the 'syngo_ontologies.xlsx' file
}
}
\examples{
  # TODO: update the filename to your downloaded file
  f = "C:/DATA/SynGO_bulk_download_release_20210225/syngo_ontologies.xlsx"
  if(file.exists(f)) genesets_asis = load_genesets_syngo(f)
}
