% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/racurve.r
\name{racurve}
\alias{racurve}
\title{Rank-abundance curves}
\usage{
racurve(matrix, main = "Rank-abundance diagram", ylog = FALSE)
}
\arguments{
\item{matrix}{Community data, a matrix-like object with samples in rows.}

\item{main}{The main title.}

\item{ylog}{If set on \code{TRUE} the y-axis is displayed on a log-scale.}
}
\description{
This function draws a rank-abundance curve for community data.
If you wish to draw multiple rank-abundance curves for selected samples use \link{racurves}.
}
\section{Details}{

Rank abundance curves or Whittaker plots (see \cite{Whittaker 1965}) are used to display relative species abundance as biodiversity component.
They are a means to visualise species richness and species evenness.
}
\examples{
## Draw simple rank-abundance curve
racurve(schedenveg)

## Draw simple rank-abundance curve with log-scaled axis
racurve(schedenveg, ylog = TRUE)
}
\author{
Friedemann Goral (\email{fgoral@gwdg.de})
}
\references{
Whittaker, R. H. (1965). Dominance and Diversity in Land Plant Communities: Numerical relations of species express the importance of competition in community function and evolution. \emph{Science} \strong{147 :} 250-260.
}
\seealso{
\code{\link{racurves}}
}

