% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_group_interaction_utility.R
\name{defineGroups_interaction}
\alias{defineGroups_interaction}
\title{To define the second mode of a DyNAM-i model}
\usage{
defineGroups_interaction(
  records,
  actors,
  seed.randomization,
  progress = getOption("progress")
)
}
\arguments{
\item{records}{an object of class \code{data.frame} that is a list of rows of type
node A, nodeB, Start, End, where nodeA and nodeB indicate the actors
involved in a dyadic interaction, and Start and End indicating the starting
and ending time of their interaction.}

\item{actors}{a object of class \code{nodes.goldfish} that defines the actors
interacting (labels in records and actors should be identical).}

\item{seed.randomization}{an \code{integer} used whenever there should
be some random choice to be made.}

\item{progress}{logical weather detailed information of intermediate steps
should be printed in the console.}
}
\value{
a \code{list} with the following data frames
\describe{
\item{interaction.updates}{containing all joining and leaving events}
\item{groups}{containing the nodeset corresponding to interaction groups
(the second mode of the network)}
\item{dependent.events}{for the events that should be modeled}
\item{exogenous.events}{that are not modeled (for example when an actor
leaves a group and joins its own singleton group, only the leaving event
is modeled but not the joining event)}
\item{composition.changes}{that is an events list that should be attached
to the groups nodeset to indicate when a group is present or not}
}
}
\description{
This function create all objects necessary to the estimation of a DyNAM-i
model \code{model = "DyNAMi"} from dyadic interaction records and an actor set.
It first creates a nodeset for the second mode of the interaction network
that will be modeled, i.e. the interaction groups set,
and an event list that indicates when groups are present or not through time.
It then creates a list of interaction events, between actors and groups,
in which an actor either joins or leaves a group. It is decomposed in
an list of dependent events (that should be modeled) and a list of
exogenous events (that should not be modeled).
For example when an actor leaves a group and joins her own singleton group,
only the leaving event is modeled but not the joining one, and vice versa
when an actor belonging to a singleton group joins another group.
}
\details{
It is important to notice that sometimes some random decisions have to
be made regarding who joined or left a group, for example when two actors
start interacting but we do not know who initiated the interaction.
Tot est for the robustness of such a procedure, one can use different
randomization seeds and run the model several times.
}
