% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildsteps_templates.R
\name{cr_buildstep_slack}
\alias{cr_buildstep_slack}
\title{Send a Slack message to a channel from a Cloud Build step}
\usage{
cr_buildstep_slack(
  message,
  title = "CloudBuild - $BUILD_ID",
  channel = NULL,
  username = "googleCloudRunnerBot",
  webhook = "$_SLACK_WEBHOOK",
  icon = NULL,
  colour = "#efefef"
)
}
\arguments{
\item{message}{The body of the message}

\item{title}{The title of the message}

\item{channel}{The channel to send the message to (if omitted, use Slack-configured default)}

\item{username}{The name of the sender of the message. Does not need to be a "real" username}

\item{webhook}{The Slack webhook to send to}

\item{icon}{A URL to an icon (squares between 512px and 2000px)}

\item{colour}{The RGB colour for message formatting}
}
\description{
This uses https://github.com/technosophos/slack-notify to send Slack messages
}
\details{
You will need to set up a Slack webhook first, via this \href{https://api.slack.com/messaging/webhooks}{Slack guide on using incoming webhooks}.

Once set, the default is to set this webhook to a Build macro called \code{_SLACK_WEBHOOK}, or supply it to the webhook argument.
}
\examples{
# send a message to googleAuthRverse Slack
webhook <-
 "https://hooks.slack.com/services/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"
cr_buildstep_slack("Hello Slack", webhook = webhook)

\dontrun{

bs <- cr_build_yaml(steps = cr_buildstep_slack("Hello Slack"))

cr_build(bs, substitutions = list(`_SLACK_WEBHOOK` = webhook))

}

}
\seealso{
Other Cloud Buildsteps: 
\code{\link{cr_buildstep_bash}()},
\code{\link{cr_buildstep_decrypt}()},
\code{\link{cr_buildstep_df}()},
\code{\link{cr_buildstep_docker}()},
\code{\link{cr_buildstep_edit}()},
\code{\link{cr_buildstep_extract}()},
\code{\link{cr_buildstep_gitsetup}()},
\code{\link{cr_buildstep_mailgun}()},
\code{\link{cr_buildstep_nginx_setup}()},
\code{\link{cr_buildstep_pkgdown}()},
\code{\link{cr_buildstep_run}()},
\code{\link{cr_buildstep_r}()},
\code{\link{cr_buildstep}()}
}
\concept{Cloud Buildsteps}
