% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildsteps_templates.R
\name{cr_buildstep_r}
\alias{cr_buildstep_r}
\title{Run an R script in a Cloud Build R step}
\usage{
cr_buildstep_r(
  r,
  name = "r-base",
  r_source = c("local", "runtime"),
  prefix = "rocker/",
  ...
)
}
\arguments{
\item{r}{R code to run or a file containing R code ending with .R, or the gs:// location on Cloud Storage of the R file you want to run}

\item{name}{The docker image that will run the R code, usually from rocker-project.org}

\item{r_source}{Whether the R code will be from a runtime file within the source or at build time copying over from a local R file in your session}

\item{prefix}{prefixed to name - set to "" to suppress.  Will be suppressed if \code{name} starts with gcr.io}

\item{...}{Other arguments passed to \link{cr_buildstep}}
}
\description{
Helper to run R code within build steps, from either an existing local R file or within the source of the build.
}
\details{
If \code{r_source="runtime"} then \code{r} should be the location of that file within the source or \code{image} that will be run by the R code from \code{image}

If \code{r_source="local"} then it will copy over from a character string or local file into the build step directly.

If the R code location starts with \code{gs://} then an extra buildstep will be added that will download the R script from that location then run it as per \code{r_source="runtime"}.  This will consequently override your setting of \code{r_source}
}
\examples{
cr_project_set("my-project")
cr_bucket_set("my-bucket")

# create an R buildstep inline
cr_buildstep_r(c("paste('1+1=', 1+1)", "sessionInfo()"))

\dontrun{

# create an R buildstep from a local file
cr_buildstep_r("my-r-file.R")

# create an R buildstep from a file within the source of the Build
cr_buildstep_r("inst/schedule/schedule.R", r_source = "runtime")

}

# use a different Rocker image e.g. rocker/verse
cr_buildstep_r(c("library(dplyr)",
                 "mtcars \%>\% select(mpg)",
                 "sessionInfo()"),
               name = "verse")

# use your own R image with custom R
my_r <- c("devtools::install()", "pkgdown::build_site()")
br <-  cr_buildstep_r(my_r, name= "gcr.io/gcer-public/packagetools:master")



}
\seealso{
Other Cloud Buildsteps: 
\code{\link{cr_buildstep_bash}()},
\code{\link{cr_buildstep_decrypt}()},
\code{\link{cr_buildstep_df}()},
\code{\link{cr_buildstep_docker}()},
\code{\link{cr_buildstep_edit}()},
\code{\link{cr_buildstep_extract}()},
\code{\link{cr_buildstep_gitsetup}()},
\code{\link{cr_buildstep_mailgun}()},
\code{\link{cr_buildstep_nginx_setup}()},
\code{\link{cr_buildstep_pkgdown}()},
\code{\link{cr_buildstep_run}()},
\code{\link{cr_buildstep_secret}()},
\code{\link{cr_buildstep_slack}()},
\code{\link{cr_buildstep}()}
}
\concept{Cloud Buildsteps}
