% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildsteps_templates.R
\name{cr_buildstep_decrypt}
\alias{cr_buildstep_decrypt}
\title{Create a build step for decrypting files via KMS}
\usage{
cr_buildstep_decrypt(cipher, plain, keyring, key, location = "global", ...)
}
\arguments{
\item{cipher}{The file that has been encrypted}

\item{plain}{The file location to decrypt to}

\item{keyring}{The KMS keyring to use}

\item{key}{The KMS key to use}

\item{location}{The KMS location}

\item{...}{Further arguments passed in to \link{cr_buildstep}}
}
\description{
Create a build step to decrypt files using CryptoKey from Cloud Key Management Service.
Usually you will prefer to use \link{cr_buildstep_secret}
}
\details{
Key Management Store can encrypt secret files for use within your later buildsteps.
}
\section{Setup}{


You will need to set up the \href{https://cloud.google.com/cloud-build/docs/securing-builds/use-encrypted-secrets-credentials#encrypt_credentials}{encrypted key using gcloud} following the link from Google
}

\examples{
cr_project_set("my-project")
cr_bucket_set("my-bucket")
cr_buildstep_decrypt("secret.json.enc",
                     plain = "secret.json",
                     keyring = "my_keyring",
                     key = "my_key")
}
\seealso{
Other Cloud Buildsteps: 
\code{\link{cr_buildstep_bash}()},
\code{\link{cr_buildstep_df}()},
\code{\link{cr_buildstep_docker}()},
\code{\link{cr_buildstep_edit}()},
\code{\link{cr_buildstep_extract}()},
\code{\link{cr_buildstep_gcloud}()},
\code{\link{cr_buildstep_gitsetup}()},
\code{\link{cr_buildstep_mailgun}()},
\code{\link{cr_buildstep_nginx_setup}()},
\code{\link{cr_buildstep_pkgdown}()},
\code{\link{cr_buildstep_run}()},
\code{\link{cr_buildstep_r}()},
\code{\link{cr_buildstep_secret}()},
\code{\link{cr_buildstep_slack}()},
\code{\link{cr_buildstep}()}
}
\concept{Cloud Buildsteps}
