% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudscheduler.R
\name{cr_schedule_pause}
\alias{cr_schedule_pause}
\alias{cr_schedule_resume}
\title{Pauses and resumes a scheduled job.}
\usage{
cr_schedule_pause(x, region = cr_region_get(), projectId = cr_project_get())

cr_schedule_resume(x, region = cr_region_get(), projectId = cr_project_get())
}
\arguments{
\item{x}{The name of the scheduled job or a \link{Job} object}

\item{region}{The region to run within}

\item{projectId}{The projectId}
}
\description{
If a job is paused then the system will stop executing the job until it is re-enabled via \link{cr_schedule_resume}.
}
\details{
The state of the job is stored in state; if paused it will be set to Job.State.PAUSED. A job must be in Job.State.ENABLED to be paused.
}
\examples{

\dontrun{
cr_project_set("my-project")
cr_region_set("europe-west1")
cr_schedule_pause("cloud-build-test1")
cr_schedule_resume("cloud-build-test1")
}
}
\seealso{
\href{https://cloud.google.com/scheduler/docs/reference/rest/v1/projects.locations.jobs/pause}{cloudscheduler.projects.locations.jobs.pause}

\href{https://cloud.google.com/scheduler/}{cloudscheduler.projects.locations.jobs.resume}

Other Cloud Scheduler functions: 
\code{\link{HttpTarget}()},
\code{\link{Job}()},
\code{\link{cr_build_schedule_http}()},
\code{\link{cr_schedule_delete}()},
\code{\link{cr_schedule_get}()},
\code{\link{cr_schedule_list}()},
\code{\link{cr_schedule_run}()},
\code{\link{cr_schedule}()}
}
\concept{Cloud Scheduler functions}
