% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssh_admin.R
\name{gce_ssh_setup}
\alias{gce_ssh_setup}
\title{Setup a SSH connection with GCE from a new SSH key-pair}
\usage{
gce_ssh_setup(instance, key.pub = NULL, key.private = NULL,
  ssh_overwrite = FALSE, username = Sys.info()[["user"]])
}
\arguments{
\item{instance}{Name of the instance of run ssh command upon}

\item{key.pub}{The filepath location of the public key, only needed first call per session}

\item{key.private}{The filepath location of the private key, only needed first call per session}

\item{ssh_overwrite}{Will check if SSH settings already set and overwrite them if TRUE}

\item{username}{The username you used to generate the key-pair}
}
\value{
TRUE if successful
}
\description{
Uploads ssh-keys to an instance
}
\details{
This loads a public ssh-key to an instance's metadata.  It does not use the project SSH-Keys, that may be set seperatly.

You will need to generate a new SSH key-pair if you have not connected to an instance before. 

Instructions for this can be found here: \url{https://cloud.google.com/compute/docs/instances/connecting-to-instance}.  Once you have generated run this function once to initiate setup.

If you have historically connected via gcloud or some other means, ssh keys may have been generated automatically.  These will be looked for and used if found, at \code{file.path(Sys.getenv("HOME"), ".ssh", "google_compute_engine.pub")}
}
\seealso{
\url{https://cloud.google.com/compute/docs/instances/adding-removing-ssh-keys}

Other ssh functions: \code{\link{gce_ssh_browser}},
  \code{\link{gce_ssh}}
}

