% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssh.R
\name{gce_ssh}
\alias{gce_ssh}
\alias{gce_ssh_upload}
\alias{gce_ssh_download}
\title{Remotely execute ssh code, upload & download files.}
\usage{
gce_ssh(instance, ..., key.pub = NULL, key.private = NULL, wait = TRUE,
  capture_text = "", username = Sys.info()[["user"]])

gce_ssh_upload(instance, local, remote, username = Sys.info()[["user"]],
  key.pub = NULL, key.private = NULL, verbose = FALSE, wait = TRUE)

gce_ssh_download(instance, remote, local, username = Sys.info()[["user"]],
  key.pub = NULL, key.private = NULL, verbose = FALSE,
  overwrite = FALSE, wait = TRUE)
}
\arguments{
\item{instance}{Name of the instance of run ssh command upon}

\item{...}{Shell commands to run. Multiple commands are combined with
\code{&&} so that execution will halt after the first failure.}

\item{key.pub}{The filepath location of the public key}

\item{key.private}{The filepath location of the private key}

\item{wait}{Whether then SSH output should be waited for or run it asynchronously.}

\item{capture_text}{Possible values are "", to the R console (the default), NULL or FALSE (discard output), TRUE (capture the output in a character vector) or a character string naming a file.}

\item{username}{The username you used to generate the key-pair}

\item{local, remote}{Local and remote paths.}

\item{verbose}{If TRUE, will print command before executing it.}

\item{overwrite}{If TRUE, will overwrite the local file if exists.}
}
\description{
Assumes that you have ssh & scp installed.  If on Windows see website and examples for workarounds.
}
\details{
Only works connecting to linux based instances.

On Windows you will need to install an ssh command line client - see examples for an example using RStudio's built in client. 

You will need to generate a new SSH key-pair if you have not connected to the instance before via say the gcloud SDK.

To customise SSH connection see \link{gce_ssh_setup}

\code{capture_text} is passed to \code{stdout} and \code{stderr} of \link{system2} 

Otherwise, instructions for generating SSH keys can be found here: \url{https://cloud.google.com/compute/docs/instances/connecting-to-instance}.

Uploads and downloads are recursive, so if you specify a directory,
everything inside the directory will also be downloaded.
}
\examples{

\dontrun{
  
  
  vm <- gce_vm("my-instance")
  
  ## if you have already logged in via gcloud, the default keys will be used
  ## no need to run gce_ssh_addkeys
  ## run command on instance            
  gce_ssh(vm, "echo foo")
  #> foo
  
  ## if running on Windows, use the RStudio default SSH client
  ## e.g. add C:\\Program Files\\RStudio\\bin\\msys-ssh-1000-18 to your PATH
  ## then run: 
  vm2 <- gce_vm("my-instance2")

  ## add SSH info to the VM object
  ## custom info
  vm2 <- gce_ssh_setup(vm2,
                      username = "mark", 
                      key.pub = "C://.ssh/id_rsa.pub",
                      key.private = "C://.ssh/id_rsa")
                      
  ## run command on instance            
  gce_ssh(vm2, "echo foo")
  #> foo


}

}
\seealso{
\url{https://cloud.google.com/compute/docs/instances/connecting-to-instance}

Other ssh functions: \code{\link{gce_ssh_addkeys}},
  \code{\link{gce_ssh_browser}},
  \code{\link{gce_ssh_setup}}
}
