% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{gl_auth}
\alias{gl_auth}
\alias{gl_auto_auth}
\title{Authenticate with Google language API services}
\usage{
gl_auth(json_file)

gl_auto_auth(...)
}
\arguments{
\item{json_file}{Authentication json file you have downloaded from your Google Project}

\item{...}{additional argument to
pass to \code{\link{gar_attach_auto_auth}}.}
}
\description{
Authenticate with Google language API services
}
\details{
The best way to authenticate is to use an environment argument pointing at your authentication file.

Set the file location of your download Google Project JSON file in a \code{GL_AUTH} argument

Then, when you load the library you should auto-authenticate

However, you can authenticate directly using this function pointing at your JSON auth file.
}
\examples{

\dontrun{
library(googleLanguageR)
gl_auth("location_of_json_file.json")
}

\dontrun{
library(googleLanguageR)
gl_auto_auth()
gl_auto_auth(environment_var = "GAR_AUTH_FILE")
}
}
