% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_rename.R
\name{drive_rename}
\alias{drive_rename}
\title{Rename a Drive file}
\usage{
drive_rename(file, name = NULL, overwrite = NA, verbose = TRUE)
}
\arguments{
\item{file}{Something that identifies the file of interest on your Google
Drive. Can be a name or path, a file id or URL marked with \code{\link[=as_id]{as_id()}}, or a
\code{\link{dribble}}.}

\item{name}{Character. Name you would like the file to have.}

\item{overwrite}{Logical, indicating whether to check for a pre-existing file
at the targetted "filepath". The quotes around "filepath" refer to the fact
that Drive does not impose a 1-to-1 relationship between filepaths and files,
like a typical file system; read more about that in \code{\link[=drive_get]{drive_get()}}.
\itemize{
\item \code{NA} (default): Just do the operation, even if it results in multiple
files with the same filepath.
\item \code{TRUE}: Check for a pre-existing file at the filepath. If there is
zero or one, move a pre-existing file to the trash, then carry on. Note
that the new file does not inherit any properties from the old one, such
as sharing or publishing settings. It will have a new file ID. An error is
thrown if two or more pre-existing files are found.
\item \code{FALSE}: Error if there is any pre-existing file at the filepath.
}

Note that existence checks, based on filepath, are expensive operations, i.e.
they require additional API calls.}

\item{verbose}{Logical, indicating whether to print informative messages
(default \code{TRUE}).}
}
\value{
An object of class \code{\link{dribble}}, a tibble with one row per item.
}
\description{
This is a wrapper for \code{\link[=drive_mv]{drive_mv()}} that only renames a file.
If you would like to rename AND move the file, see \code{\link[=drive_mv]{drive_mv()}}.
}
\examples{
\dontrun{
## Create a file to rename
file <- drive_create("file-to-rename")

## Rename it
file <- drive_rename(file, name = "renamed-file")

## `overwrite = FALSE` errors if something already exists at target filepath
## THIS WILL ERROR!
drive_create("name-squatter")
drive_rename(file, name = "name-squatter", overwrite = FALSE)

## `overwrite = TRUE` moves the existing item to trash, then proceeds
file <- drive_rename(file, name = "name-squatter", overwrite = TRUE)

## Clean up
drive_rm(file)
}
}
