% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gs_copy.R
\name{gs_copy}
\alias{gs_copy}
\title{Copy an existing spreadsheet}
\usage{
gs_copy(from, to = NULL, verbose = TRUE)
}
\arguments{
\item{from}{a registered Google spreadsheet, i.e. a \code{\link{googlesheet}}
object}

\item{to}{character string giving the new title of the sheet; if \code{NULL},
then the copy will be titled "Copy of ..."}

\item{verbose}{logical; do you want informative messages?}
}
\description{
You can copy a spreadsheet that you own or a sheet owned by a third party
that has been made accessible via the sharing dialog options. This function
calls the \href{https://developers.google.com/drive/v2/reference/}{Google
Drive API}.
}
\examples{
\dontrun{
# copy the Gapminder example sheet
gap_ss <- gs_copy(gs_gap(), to = "Gapminder_copy")
gap_ss
gs_delete(gap_ss)
}

}
