% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheet_resize.R
\name{sheet_resize}
\alias{sheet_resize}
\title{Change the size of a (work)sheet}
\usage{
sheet_resize(ss, sheet = NULL, nrow = NULL, ncol = NULL, exact = FALSE)
}
\arguments{
\item{ss}{Something that identifies a Google Sheet: its file ID, a URL from
which we can recover the ID, an instance of \code{googlesheets4_spreadsheet}
(returned by \code{\link[=gs4_get]{gs4_get()}}), or a \code{\link[googledrive:dribble]{dribble}}, which
is how googledrive represents Drive files. Processed through
\code{\link[=as_sheets_id]{as_sheets_id()}}.}

\item{sheet}{Sheet to resize, in the sense of "worksheet" or "tab". You can identify a sheet by name, with a string, or by position, with a number.}

\item{nrow, ncol}{Desired number of rows or columns, respectively. The default
of \code{NULL} means to leave unchanged.}

\item{exact}{Logical, indicating whether to impose \code{nrow} and \code{ncol} exactly
or to treat them as lower bounds. If \code{exact = FALSE},
\code{sheet_resize()} can only add cells. If \code{exact = TRUE}, cells can be
deleted and their contents are lost.}
}
\value{
The input \code{ss}, as an instance of \code{\link{sheets_id}}
}
\description{
Changes the number of rows and/or columns in a (work)sheet.
}
\examples{
if (gs4_has_token()) {
  # create a Sheet with the default initial worksheet
  (ss <- gs4_create("sheet-resize-demo"))

  # see (work)sheet dims
  sheet_properties(ss)

  # no resize occurs
  sheet_resize(ss, nrow = 2, ncol = 6)

  # reduce sheet size
  sheet_resize(ss, nrow = 5, ncol = 7, exact = TRUE)

  # add rows
  sheet_resize(ss, nrow = 7)

  # add columns
  sheet_resize(ss, ncol = 10)

  # add rows and columns
  sheet_resize(ss, nrow = 9, ncol = 12)

  # re-inspect (work)sheet dims
  sheet_properties(ss)

  # clean up
  gs4_find("sheet-resize-demo") \%>\%
    googledrive::drive_trash()
}
}
\seealso{
Makes an \code{UpdateSheetPropertiesRequest}:
\itemize{
\item <# https://developers.google.com/sheets/api/reference/rest/v4/spreadsheets/request#UpdateSheetPropertiesRequest>
}

Other worksheet functions: 
\code{\link{sheet_add}()},
\code{\link{sheet_append}()},
\code{\link{sheet_copy}()},
\code{\link{sheet_delete}()},
\code{\link{sheet_properties}()},
\code{\link{sheet_relocate}()},
\code{\link{sheet_rename}()},
\code{\link{sheet_write}()}
}
\concept{worksheet functions}
