% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodeinfo.R
\name{node_labels}
\alias{node_labels}
\alias{node_rules}
\alias{top_items}
\alias{plot.pltree}
\title{Get node labels and rules used in a party tree}
\usage{
node_labels(x)

node_rules(x)

top_items(x, top = 5)

\method{plot}{pltree}(x, log = TRUE, ref = NULL, ci.level = 0.95, ...)
}
\arguments{
\item{x}{an object of class \code{party}}

\item{top}{an integer for the number of items to return}

\item{log}{logical, if \code{TRUE} log-worth coefficients are 
displayed instead of worth}

\item{ref}{optional, character for the reference item when
\var{log} = \code{TRUE}}

\item{ci.level}{an integer for the confidence interval levels}

\item{...}{additional arguments passed to methods}
}
\value{
a vector with the node labels, 
 a data.frame with node rules, a ggplot
}
\description{
Returns the covariates used to split a recursive
 partitioning tree and the rules that were applied 
 to build the tree
}
\examples{
\donttest{
library("PlackettLuce")
data("beans", package = "PlackettLuce")
G <- rank_tricot(data = beans,
                 items = c(1:3),
                 input = c(4:5),
                 group = TRUE,
                 additional.rank = beans[c(6:8)])
 
pld <- cbind(G, beans[,c("maxTN", "season", "lon")])

tree <- pltree(G ~ maxTN + season + lon, data = pld)

node_labels(tree)

node_rules(tree)

top_items(tree)

plot(tree)

plot(tree, log = TRUE)
}
}
\author{
Kauê de Sousa
}
