% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keys.R
\name{gpg_import}
\alias{gpg_delete}
\alias{gpg_export}
\alias{gpg_import}
\alias{gpg_keylist}
\alias{gpg_recv}
\title{GPG keyring management}
\usage{
gpg_import(file)

gpg_recv(id, keyserver = "https://keyserver.ubuntu.com")

gpg_delete(id, secret = TRUE)

gpg_export(id, secret = FALSE)

gpg_keylist(secret = FALSE)
}
\arguments{
\item{file}{path to the key file or raw vector with key data}

\item{id}{unique ID of the pubkey (starts with \code{0x})}

\item{keyserver}{address of http keyserver}

\item{secret}{set to \code{TRUE} to list/export/delete private (secret) keys}
}
\description{
Signing or encrypting with GPG require that the keys are stored in your
personal keyring. Use \link{gpg_version} to see which keyring (home dir)
you are using. Also see \link{gpg_keygen} for generating a new key.
}

