# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Generate trace back.
#' 
#' This function returns the  trace back, i.e. the sequence of most probable 
#' states in the alignment between read x and reference sequence y.
#'
#' @param q double, index of the state for the last two nucleotides in the read and reference sequence.
#' @param i double, length of the read.
#' @param j double, length of the reference sequence.
#' @param Tm matrix, GPHMM probabilities at each location in the read and reference sequence in the M state.
#' @param Tx matrix, GPHMM probabilities at each location in the read and reference sequence in the insertion state.
#' @param Ty matrix, GPHMM probabilities at each location in the read and reference sequence in the deletion state.
#'
NULL

#' Calculate GPHMM probability.
#' 
#' This function returns the GPHMM probability that a read x could have been
#' sequenced from a reference sequence y.
#'
#' @param x string, with the sequence of the read.
#' @param y string, with the sequence of the reference.
#' @param tau double, probability to transition from any state to end state.
#' @param pp matrix, emission probabilities in the M state.
#' @param qX vector, emission probabilities in the insertion state.
#' @param qY vector, emission probabilities in the deletion state.
#' @param dX double, transition probability from the M to the insertion state.
#' @param dY double, transition probability from the M to the deletion state.
#' @param eX double, transition probability from the insertion to the insertion state.
#' @param eY double, transition probability from the deletion to the deletion state.
#' 
#' @export
#' @examples
#' param <- initializeGphmm()
#' tau <- param[['tau']]
#' pp <- param[['pp']]
#' qX <- param[['qX']]
#' qY <- param[['qY']]
#' dX <- 1/(1+exp(-sum(param[['deltaX']] * c(1, 20))))
#' dY <- 1/(1+exp(-sum(param[['deltaY']] * c(1, 20))))
#' eX <- param[['epsX']]
#' eY <- param[['epsY']]
#' calculategphmm('ATCG', 'ATGG', tau, pp, qX, qY, dX, dY, eX, eY)
calculategphmm <- function(x, y, tau, pp, qX, qY, dX, dY, eX, eY) {
    .Call('_gphmm_calculategphmm', PACKAGE = 'gphmm', x, y, tau, pp, qX, qY, dX, dY, eX, eY)
}

