# This file was generated by Rcpp::compileAttributes
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

cpp_detectCPUs <- function(platform_idx) {
    .Call('gpuR_cpp_detectCPUs', PACKAGE = 'gpuR', platform_idx)
}

cpp_detectGPUs <- function(platform_idx) {
    .Call('gpuR_cpp_detectGPUs', PACKAGE = 'gpuR', platform_idx)
}

#' @title Detect Number of Platforms
#' @description Find out how many OpenCL enabled platforms are available.
#' @return An integer value representing the number of platforms available.
#' @seealso \link{detectGPUs}
#' @export
detectPlatforms <- function() {
    .Call('gpuR_detectPlatforms', PACKAGE = 'gpuR')
}

cpp_device_has_double <- function(platform_idx_, gpu_idx_) {
    .Call('gpuR_cpp_device_has_double', PACKAGE = 'gpuR', platform_idx_, gpu_idx_)
}

GetVecElement <- function(ptrA, idx, type_flag) {
    .Call('gpuR_GetVecElement', PACKAGE = 'gpuR', ptrA, idx, type_flag)
}

SetVecElement <- function(ptrA, idx, value, type_flag) {
    invisible(.Call('gpuR_SetVecElement', PACKAGE = 'gpuR', ptrA, idx, value, type_flag))
}

SetMatRow <- function(ptrA, idx, value, type_flag) {
    invisible(.Call('gpuR_SetMatRow', PACKAGE = 'gpuR', ptrA, idx, value, type_flag))
}

SetMatCol <- function(ptrA, idx, value, type_flag) {
    invisible(.Call('gpuR_SetMatCol', PACKAGE = 'gpuR', ptrA, idx, value, type_flag))
}

SetMatElement <- function(ptrA, nr, nc, value, type_flag) {
    invisible(.Call('gpuR_SetMatElement', PACKAGE = 'gpuR', ptrA, nr, nc, value, type_flag))
}

GetMatRow <- function(ptrA, idx, type_flag) {
    .Call('gpuR_GetMatRow', PACKAGE = 'gpuR', ptrA, idx, type_flag)
}

GetMatCol <- function(ptrA, idx, type_flag) {
    .Call('gpuR_GetMatCol', PACKAGE = 'gpuR', ptrA, idx, type_flag)
}

GetMatElement <- function(ptrA, nr, nc, type_flag) {
    .Call('gpuR_GetMatElement', PACKAGE = 'gpuR', ptrA, nr, nc, type_flag)
}

vectorToSEXP <- function(ptrA, type_flag) {
    .Call('gpuR_vectorToSEXP', PACKAGE = 'gpuR', ptrA, type_flag)
}

vectorToMat <- function(ptrA, nr, nc, type_flag) {
    .Call('gpuR_vectorToMat', PACKAGE = 'gpuR', ptrA, nr, nc, type_flag)
}

matrixToGPUXptr <- function(ptrA, type_flag) {
    .Call('gpuR_matrixToGPUXptr', PACKAGE = 'gpuR', ptrA, type_flag)
}

VecXptrToVecSEXP <- function(ptrA, type_flag) {
    .Call('gpuR_VecXptrToVecSEXP', PACKAGE = 'gpuR', ptrA, type_flag)
}

MatXptrToMatSEXP <- function(ptrA, type_flag) {
    .Call('gpuR_MatXptrToMatSEXP', PACKAGE = 'gpuR', ptrA, type_flag)
}

emptyVecXptr <- function(size, type_flag) {
    .Call('gpuR_emptyVecXptr', PACKAGE = 'gpuR', size, type_flag)
}

emptyMatXptr <- function(nr, nc, type_flag) {
    .Call('gpuR_emptyMatXptr', PACKAGE = 'gpuR', nr, nc, type_flag)
}

cpp_gpuInfo <- function(platform_idx_, gpu_idx_) {
    .Call('gpuR_cpp_gpuInfo', PACKAGE = 'gpuR', platform_idx_, gpu_idx_)
}

cpp_gpuMatrix_iaxpy <- function(alpha_, ptrA_, ptrB_, sourceCode_) {
    invisible(.Call('gpuR_cpp_gpuMatrix_iaxpy', PACKAGE = 'gpuR', alpha_, ptrA_, ptrB_, sourceCode_))
}

cpp_gpuMatrix_igemm <- function(ptrA_, ptrB_, ptrC_, sourceCode_) {
    invisible(.Call('gpuR_cpp_gpuMatrix_igemm', PACKAGE = 'gpuR', ptrA_, ptrB_, ptrC_, sourceCode_))
}

cpp_gpu_two_vec <- function(ptrA_, ptrB_, ptrC_, sourceCode_, kernel_function_) {
    invisible(.Call('gpuR_cpp_gpu_two_vec', PACKAGE = 'gpuR', ptrA_, ptrB_, ptrC_, sourceCode_, kernel_function_))
}

cpp_gpuVector_iaxpy <- function(alpha_, ptrA_, ptrB_, sourceCode_) {
    invisible(.Call('gpuR_cpp_gpuVector_iaxpy', PACKAGE = 'gpuR', alpha_, ptrA_, ptrB_, sourceCode_))
}

cpp_platformInfo <- function(platform_idx_) {
    .Call('gpuR_cpp_platformInfo', PACKAGE = 'gpuR', platform_idx_)
}

truncIntgpuMat <- function(ptrA_, nr, nc) {
    .Call('gpuR_truncIntgpuMat', PACKAGE = 'gpuR', ptrA_, nr, nc)
}

truncFloatgpuMat <- function(ptrA_, nr, nc) {
    .Call('gpuR_truncFloatgpuMat', PACKAGE = 'gpuR', ptrA_, nr, nc)
}

truncDoublegpuMat <- function(ptrA_, nr, nc) {
    .Call('gpuR_truncDoublegpuMat', PACKAGE = 'gpuR', ptrA_, nr, nc)
}

cpp_dncol <- function(ptrA) {
    .Call('gpuR_cpp_dncol', PACKAGE = 'gpuR', ptrA)
}

cpp_fncol <- function(ptrA) {
    .Call('gpuR_cpp_fncol', PACKAGE = 'gpuR', ptrA)
}

cpp_incol <- function(ptrA) {
    .Call('gpuR_cpp_incol', PACKAGE = 'gpuR', ptrA)
}

cpp_dnrow <- function(ptrA) {
    .Call('gpuR_cpp_dnrow', PACKAGE = 'gpuR', ptrA)
}

cpp_fnrow <- function(ptrA) {
    .Call('gpuR_cpp_fnrow', PACKAGE = 'gpuR', ptrA)
}

cpp_inrow <- function(ptrA) {
    .Call('gpuR_cpp_inrow', PACKAGE = 'gpuR', ptrA)
}

cpp_dgpuVec_size <- function(ptrA) {
    .Call('gpuR_cpp_dgpuVec_size', PACKAGE = 'gpuR', ptrA)
}

cpp_fgpuVec_size <- function(ptrA) {
    .Call('gpuR_cpp_fgpuVec_size', PACKAGE = 'gpuR', ptrA)
}

cpp_igpuVec_size <- function(ptrA) {
    .Call('gpuR_cpp_igpuVec_size', PACKAGE = 'gpuR', ptrA)
}

vcl_dncol <- function(ptrA) {
    .Call('gpuR_vcl_dncol', PACKAGE = 'gpuR', ptrA)
}

vcl_fncol <- function(ptrA) {
    .Call('gpuR_vcl_fncol', PACKAGE = 'gpuR', ptrA)
}

vcl_incol <- function(ptrA) {
    .Call('gpuR_vcl_incol', PACKAGE = 'gpuR', ptrA)
}

vcl_dnrow <- function(ptrA) {
    .Call('gpuR_vcl_dnrow', PACKAGE = 'gpuR', ptrA)
}

vcl_fnrow <- function(ptrA) {
    .Call('gpuR_vcl_fnrow', PACKAGE = 'gpuR', ptrA)
}

vcl_inrow <- function(ptrA) {
    .Call('gpuR_vcl_inrow', PACKAGE = 'gpuR', ptrA)
}

vcl_dgpuVec_size <- function(ptrA) {
    .Call('gpuR_vcl_dgpuVec_size', PACKAGE = 'gpuR', ptrA)
}

vcl_fgpuVec_size <- function(ptrA) {
    .Call('gpuR_vcl_fgpuVec_size', PACKAGE = 'gpuR', ptrA)
}

vcl_igpuVec_size <- function(ptrA) {
    .Call('gpuR_vcl_igpuVec_size', PACKAGE = 'gpuR', ptrA)
}

matrixToVCL <- function(ptrA, type_flag) {
    .Call('gpuR_matrixToVCL', PACKAGE = 'gpuR', ptrA, type_flag)
}

VCLtoMatSEXP <- function(ptrA, type_flag) {
    .Call('gpuR_VCLtoMatSEXP', PACKAGE = 'gpuR', ptrA, type_flag)
}

emptyVCL <- function(nr, nc, type_flag) {
    .Call('gpuR_emptyVCL', PACKAGE = 'gpuR', nr, nc, type_flag)
}

vclSetCol <- function(ptrA, nc, newdata, type_flag) {
    invisible(.Call('gpuR_vclSetCol', PACKAGE = 'gpuR', ptrA, nc, newdata, type_flag))
}

vclSetRow <- function(ptrA, nr, newdata, type_flag) {
    invisible(.Call('gpuR_vclSetRow', PACKAGE = 'gpuR', ptrA, nr, newdata, type_flag))
}

vclSetElement <- function(ptrA, nr, nc, newdata, type_flag) {
    invisible(.Call('gpuR_vclSetElement', PACKAGE = 'gpuR', ptrA, nr, nc, newdata, type_flag))
}

vclGetCol <- function(ptrA, nc, type_flag) {
    .Call('gpuR_vclGetCol', PACKAGE = 'gpuR', ptrA, nc, type_flag)
}

vclGetRow <- function(ptrA, nr, type_flag) {
    .Call('gpuR_vclGetRow', PACKAGE = 'gpuR', ptrA, nr, type_flag)
}

vclGetElement <- function(ptrA, nr, nc, type_flag) {
    .Call('gpuR_vclGetElement', PACKAGE = 'gpuR', ptrA, nr, nc, type_flag)
}

vclVecGetElement <- function(ptrA, idx, type_flag) {
    .Call('gpuR_vclVecGetElement', PACKAGE = 'gpuR', ptrA, idx, type_flag)
}

vclVecSetElement <- function(ptrA, idx, newdata, type_flag) {
    invisible(.Call('gpuR_vclVecSetElement', PACKAGE = 'gpuR', ptrA, idx, newdata, type_flag))
}

vectorToVCL <- function(ptrA, type_flag, device_flag) {
    .Call('gpuR_vectorToVCL', PACKAGE = 'gpuR', ptrA, type_flag, device_flag)
}

vectorToMatVCL <- function(ptrA, nr, nc, type_flag, device_flag) {
    .Call('gpuR_vectorToMatVCL', PACKAGE = 'gpuR', ptrA, nr, nc, type_flag, device_flag)
}

VCLtoVecSEXP <- function(ptrA, type_flag) {
    .Call('gpuR_VCLtoVecSEXP', PACKAGE = 'gpuR', ptrA, type_flag)
}

emptyVecVCL <- function(length, type_flag, device_flag) {
    .Call('gpuR_emptyVecVCL', PACKAGE = 'gpuR', length, type_flag, device_flag)
}

cpp_gpuMatrix_elem_prod <- function(ptrA, ptrB, ptrC, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_prod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, device_flag, type_flag))
}

cpp_gpuMatrix_elem_div <- function(ptrA, ptrB, ptrC, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_div', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, device_flag, type_flag))
}

cpp_gpuMatrix_elem_sin <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_sin', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuMatrix_elem_asin <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_asin', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuMatrix_elem_sinh <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_sinh', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuMatrix_elem_cos <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_cos', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuMatrix_elem_acos <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_acos', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuMatrix_elem_cosh <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_cosh', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuMatrix_elem_tan <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_tan', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuMatrix_elem_atan <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_atan', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuMatrix_elem_tanh <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_tanh', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuMatrix_elem_log <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_log', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuMatrix_elem_log_base <- function(ptrA, ptrB, base, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_log_base', PACKAGE = 'gpuR', ptrA, ptrB, base, device_flag, type_flag))
}

cpp_gpuMatrix_elem_log10 <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_log10', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuMatrix_elem_exp <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_elem_exp', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuMatrix_axpy <- function(alpha, ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_axpy', PACKAGE = 'gpuR', alpha, ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_axpy <- function(alpha, ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_axpy', PACKAGE = 'gpuR', alpha, ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_elem_prod <- function(ptrA, ptrB, ptrC, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_prod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, device_flag, type_flag))
}

cpp_vclMatrix_elem_div <- function(ptrA, ptrB, ptrC, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_div', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, device_flag, type_flag))
}

cpp_vclMatrix_elem_sin <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_sin', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_elem_asin <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_asin', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_elem_sinh <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_sinh', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_elem_cos <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_cos', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_elem_acos <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_acos', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_elem_cosh <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_cosh', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_elem_tan <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_tan', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_elem_atan <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_atan', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_elem_tanh <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_tanh', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_elem_log <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_log', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_elem_log10 <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_log10', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_elem_log_base <- function(ptrA, ptrB, base, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_log_base', PACKAGE = 'gpuR', ptrA, ptrB, base, device_flag, type_flag))
}

cpp_vclMatrix_elem_exp <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_elem_exp', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuVector_axpy <- function(alpha, ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuVector_axpy', PACKAGE = 'gpuR', alpha, ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuVector_inner_prod <- function(ptrA, ptrB, device_flag, type_flag) {
    .Call('gpuR_cpp_gpuVector_inner_prod', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag)
}

cpp_gpuVector_outer_prod <- function(ptrA, ptrB, ptrC, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuVector_outer_prod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, device_flag, type_flag))
}

cpp_gpuVector_elem_prod <- function(ptrA, ptrB, ptrC, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_prod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, device_flag, type_flag))
}

cpp_gpuVector_elem_div <- function(ptrA, ptrB, ptrC, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_div', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, device_flag, type_flag))
}

cpp_gpuVector_elem_sin <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_sin', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuVector_elem_asin <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_asin', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuVector_elem_sinh <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_sinh', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuVector_elem_cos <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_cos', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuVector_elem_acos <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_acos', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuVector_elem_cosh <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_cosh', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuVector_elem_tan <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_tan', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuVector_elem_atan <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_atan', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuVector_elem_tanh <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuVector_elem_tanh', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclVector_axpy <- function(alpha, ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_axpy', PACKAGE = 'gpuR', alpha, ptrA, ptrB, device_flag, type_flag))
}

cpp_vclVector_inner_prod <- function(ptrA, ptrB, device_flag, type_flag) {
    .Call('gpuR_cpp_vclVector_inner_prod', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag)
}

cpp_vclVector_outer_prod <- function(ptrA, ptrB, ptrC, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_outer_prod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, device_flag, type_flag))
}

cpp_vclVector_elem_prod <- function(ptrA, ptrB, ptrC, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_prod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, device_flag, type_flag))
}

cpp_vclVector_elem_div <- function(ptrA, ptrB, ptrC, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_div', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, device_flag, type_flag))
}

cpp_vclVector_elem_sin <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_sin', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclVector_elem_asin <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_asin', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclVector_elem_sinh <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_sinh', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclVector_elem_cos <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_cos', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclVector_elem_acos <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_acos', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclVector_elem_cosh <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_cosh', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclVector_elem_tan <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_tan', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclVector_elem_atan <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_atan', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclVector_elem_tanh <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_tanh', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclVector_elem_log <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_log', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclVector_elem_log10 <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_log10', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclVector_elem_log_base <- function(ptrA, ptrB, R_base, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_log_base', PACKAGE = 'gpuR', ptrA, ptrB, R_base, device_flag, type_flag))
}

cpp_vclVector_elem_exp <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclVector_elem_exp', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuMatrix_gemm <- function(ptrA, ptrB, ptrC, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_gemm', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, device_flag, type_flag))
}

cpp_gpuMatrix_crossprod <- function(ptrA, ptrB, ptrC, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_crossprod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, device_flag, type_flag))
}

cpp_gpuMatrix_tcrossprod <- function(ptrA, ptrB, ptrC, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_tcrossprod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, device_flag, type_flag))
}

cpp_vclMatrix_gemm <- function(ptrA, ptrB, ptrC, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_gemm', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, device_flag, type_flag))
}

cpp_vclMatrix_crossprod <- function(ptrA, ptrB, ptrC, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_crossprod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, device_flag, type_flag))
}

cpp_vclMatrix_tcrossprod <- function(ptrA, ptrB, ptrC, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_tcrossprod', PACKAGE = 'gpuR', ptrA, ptrB, ptrC, device_flag, type_flag))
}

cpp_gpu_eigen <- function(Am, Qm, eigenvalues, symmetric, type_flag, device_flag) {
    invisible(.Call('gpuR_cpp_gpu_eigen', PACKAGE = 'gpuR', Am, Qm, eigenvalues, symmetric, type_flag, device_flag))
}

cpp_vcl_eigen <- function(Am, Qm, eigenvalues, symmetric, type_flag, device_flag) {
    invisible(.Call('gpuR_cpp_vcl_eigen', PACKAGE = 'gpuR', Am, Qm, eigenvalues, symmetric, type_flag, device_flag))
}

cpp_gpuMatrix_pmcc <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_pmcc', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_pmcc <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_pmcc', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_eucl <- function(ptrA, ptrD, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_eucl', PACKAGE = 'gpuR', ptrA, ptrD, device_flag, type_flag))
}

cpp_gpuMatrix_eucl <- function(ptrA, ptrD, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_eucl', PACKAGE = 'gpuR', ptrA, ptrD, device_flag, type_flag))
}

cpp_gpuMatrix_colmean <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_colmean', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuMatrix_colsum <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_colsum', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuMatrix_rowmean <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_rowmean', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_gpuMatrix_rowsum <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_gpuMatrix_rowsum', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_colmean <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_colmean', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_colsum <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_colsum', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_rowmean <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_rowmean', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

cpp_vclMatrix_rowsum <- function(ptrA, ptrB, device_flag, type_flag) {
    invisible(.Call('gpuR_cpp_vclMatrix_rowsum', PACKAGE = 'gpuR', ptrA, ptrB, device_flag, type_flag))
}

