% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6-3.1.1-types-scalars.R
\name{parse_ast}
\alias{parse_ast}
\title{Parse AST}
\usage{
parse_ast(kind, resolve)
}
\arguments{
\item{kind}{single character name of a class to parse}

\item{resolve}{function to parse the value if the kind is correct}
}
\value{
function that takes \code{obj} and \code{schema} that will only parse the value if the \code{kind} is inherited in the \code{obj}
}
\description{
This is a helper function for Scalars.  Given a particular kind and a resolve function, it produces a function that will only parse values of a particular kind.
}
\details{
Typically, \code{kind} is the same as the class of the Scalar.  When making a new Scalar, parse_ast defaults to use the name of the scalar and the scalar's parse value function.

This function should only need to be used when defining a schema in \code{\link{gqlr_schema}()}
}
\examples{
parse_date_value <- function(obj, schema) {
  as.Date(obj)
}
parse_ast("Date", parse_date_value)

# Example from Int scalar
parse_int <- function (value, ...) {
  MAX_INT <-  2147483647
  MIN_INT <- -2147483648
  num <- suppressWarnings(as.integer(value))
  if (!is.na(num)) {
    if (num <= MAX_INT && num >= MIN_INT) {
      return(num)
    }
  }
  return(NULL)
}
parse_ast("IntValue", parse_int)
}
