% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_befafter_colours.R
\name{plot_befafter_colours}
\alias{plot_befafter_colours}
\title{Plot a before-after plot with lines joining colour-matched symbols.}
\usage{
plot_befafter_colours(
  data,
  xcol,
  ycol,
  match,
  symsize = 3,
  symthick = 1,
  s_alpha = 1,
  ColPal = "all_grafify",
  ColSeq = TRUE,
  ColRev = FALSE,
  TextXAngle = 0,
  fontsize = 20,
  groups,
  ...
)
}
\arguments{
\item{data}{a data table object, e.g. data.frame or tibble.}

\item{xcol}{name of the column containing the categorical variable to be plotted on the X axis.}

\item{ycol}{name of the column containing the quantitative Y values.}

\item{match}{name of the column with the matching variable to pass on to \code{geom_line}.}

\item{symsize}{size of symbols, default set to 3.}

\item{symthick}{thickness of symbol border, default set to 1.}

\item{s_alpha}{fractional opacity of symbols, default set to 1 (i.e. maximum opacity & zero transparency).}

\item{ColPal}{grafify colour palette to apply, default "all_grafify"; alternatives: "okabe_ito", "bright", "pale", "vibrant", "contrast", "muted" "dark", "light".}

\item{ColSeq}{logical TRUE or FALSE. Default TRUE for sequential colours from chosen palette. Set to FALSE for distant colours, which will be applied using  \code{scale_fill_grafify2}.}

\item{ColRev}{whether to reverse order of colour choice, default F (FALSE); can be set to T (TRUE).}

\item{TextXAngle}{orientation of text on X-axis; default 0 degrees. Change to 45 or 90 to remove overlapping text.}

\item{fontsize}{parameter of \code{base_size} of fonts in \code{theme_classic}, default set to size 20.}

\item{groups}{old argument name for \code{match}; retained for backward compatibility.}

\item{...}{any additional arguments to pass to \code{ggplot2}\link{geom_line}.}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
The \code{\link{plot_befafter_colours}}, \code{\link{plot_befafter_colors}} and \code{\link{plot_befafter_shapes}} are for plotting matched data joined by lines. These functions take X and Y variables along with a data column with matching information (e.g. matched subjects or experiments etc.) and plot symbols matched by colour or shape.
}
\details{
Note that only 25 shapes are available, and there will be errors with \code{\link{plot_befafter_shapes}} when there are fewer than 25 matched observations; instead use \code{\link{plot_befafter_colours}} instead.

Colours can be changed using \code{ColPal}, \code{ColRev} or \code{ColSeq} arguments.
\code{ColPal} can be one of the following: "okabe_ito", "dark", "light", "bright", "pale", "vibrant,  "muted" or "contrast".
\code{ColRev} (logical TRUE/FALSE) decides whether colours are chosen from first-to-last or last-to-first from within the chosen palette.
\code{ColSeq} decides whether colours are picked by respecting the order in the palette or the most distant ones using \code{\link[grDevices]{colorRampPalette}}.

More complex designs can also be plotted when used with \code{\link[ggplot2]{facet_wrap}} or \code{\link[ggplot2]{facet_grid}}.
}
\examples{
#plot without legends if necessary
plot_befafter_colors(data = data_t_pdiff, 
xcol = Condition, ycol = Mass, 
match = Subject, s_alpha = .9, ColSeq = FALSE)+
guides(fill = "none", 
colour = "none") #remove guides
#2way ANOVA design with randomised blocks
plot_befafter_colors(data = data_2w_Tdeath, 
xcol = Genotype, ycol = PI, 
match = Experiment) + facet_wrap("Time")
}
