% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{CalibrateEffectiveLabelingTimeKineticFit}
\alias{CalibrateEffectiveLabelingTimeKineticFit}
\title{Uses the kinetic model to calibrate the effective labeling time.}
\usage{
CalibrateEffectiveLabelingTimeKineticFit(
  data,
  slot = DefaultSlot(data),
  time = Design$dur.4sU,
  time.name = "calibrated_time",
  time.conf.name = "calibrated_time_conf",
  CI.size = 0.95,
  steady.state = NULL,
  n.estimate = 1000,
  n.iter = 10000,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{data}{A grandR object}

\item{slot}{The data slot to take expression values from}

\item{time}{The column in the column annotation table representing the labeling duration}

\item{time.name}{The name in the column annotation table to put the calibrated labeling durations}

\item{time.conf.name}{The name in the column annotation table to put the confidence values for the labeling durations (half-size of the confidence interval)}

\item{CI.size}{The level for confidence intervals}

\item{steady.state}{either a named list of logical values representing conditions in steady state or not, or a single logical value for all conditions}

\item{n.estimate}{the times are calibrated with the top n expressed genes}

\item{n.iter}{the maximal number of iterations for the numerical optimization}

\item{verbose}{verbose output}

\item{...}{forwarded to FitKinetics}
}
\value{
A new grandR object containing the calibrated durations in the column data annotation
}
\description{
The NTRs of each sample might be systematically too small (or large). This function identifies such systematic
deviations and computes labeling durations without systematic deviations.
}
\details{
There are many reasons why the nominal (wall-clock) time of 4sU labeling might be distinct from the effective labeling time. Most
importantly, 4sU needs some time to enter the cells and get activated to be ready for transcription. Therefore, the 4sU concentration
(relative to the U concentration) rises, based on observations, over the timeframe of 1-2h. GRAND-SLAM assumes a constant 4sU incorporation rate,
i.e. specifically new RNA made early during the labeling is underestimated. This, especially for short labeling (<2h), the effective labeling duration
might be significantly less than the nominal labeling duration.

It is impossible to obtain a perfect absolute calibration, i.e. all durations might be off by a factor.
}
\seealso{
\link{FitKinetics}
}
\concept{recalibration}
