% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fanplot.R
\name{rf_summary}
\alias{rf_summary}
\title{Create a summary data frame for risk factors}
\usage{
rf_summary(rf_names, rf_prev, risk, log = FALSE)
}
\arguments{
\item{rf_names}{A character vector of risk factor names}

\item{rf_prev}{A numeric vector specifying prevalence of risk factor in disease controls (estimates of population prevalence can also be used if the disease is rare)}

\item{risk}{A numeric vector of relative risks or Odds ratios for disease corresponding to each risk factor (if log=FALSE).  Log-relative risks or log-odds ratios can  be alternatively specified (if log=TRUE)}

\item{log}{default TRUE. Set to TRUE if relative risks/odds ratios are specified on log-scale}
}
\value{
A rf.data.frame object
}
\description{
Create a rf.data.frame object for risk factors, prevalence and risk ratios.  This will be used in fan plots and nomograms (by simply sending the rf.dat.frame object to plot)
}
\examples{
rfs <- rf_summary(rf_names=c('Hypertension','Inactivity','ApoB/ApoA','Diet',
'WHR','Smoking','Cardiac causes','Alcohol','Global Stress','Diabetes'),
rf_prev=c(.474,.837,.669,.67,.67,.224,.049,.277,.144,.129),
risk=c(1.093,0.501,0.428,0.378,0.294,0.513,1.156,0.186,0.301,0.148),log=TRUE)
# fanplot
plot(rfs,type="f")
# nomogram
plot(rfs,type="n")
# reverse nomogram
# plot(rfs,type="rn")
}
\references{
Ferguson, J., O’Leary, N., Maturo, F., Yusuf, S. and O’Donnell, M., 2019. Graphical comparisons of relative disease burden across multiple risk factors. BMC medical research methodology, 19(1), pp.1-9.
}
