% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphClustering.R
\name{fitSBMcollection}
\alias{fitSBMcollection}
\title{Fit a unique stochastic block model to a collection of networks}
\usage{
fitSBMcollection(
  allAdj,
  hyperParam = list(alpha = 0.5, eta = 0.5, zeta = 0.5, lambda = 0.5),
  nbCores = detectCores()
)
}
\arguments{
\item{allAdj}{list of adjacency matrices}

\item{hyperParam}{hyperparameters of prior distributions}

\item{nbCores}{number of cores for parallelization. Default: detectCores().}
}
\value{
list with the following fields:
$nodeClusterings is a list with the node labels for each networks,
$theta contains the estimated SBM parameter,
$ICL is the value of the ICL criterion of the final clustering
}
\description{
fitSBMcollection() is a subversion of graphClustering() where
no stopping criterion is applied. So all networks are ultimately merged to
a single cluster and considered as i.i.d realisations of a single
stochastic block model.
}
\examples{
theta <- list(pi=c(.5,.5), gamma=matrix((1:4)/8,2,2))
obs <- rCollectSBM(rep(10,4), theta)$listGraphs
res <- fitSBMcollection(obs, nbCores=1)
}
