% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw-gam.R
\name{draw.gam}
\alias{draw.gam}
\title{Plot estimated smooths from a fitted GAM}
\usage{
\method{draw}{gam}(
  object,
  data = NULL,
  select = NULL,
  parametric = FALSE,
  terms = NULL,
  residuals = FALSE,
  scales = c("free", "fixed"),
  ci_level = 0.95,
  n = 100,
  n_3d = 16,
  n_4d = 4,
  unconditional = FALSE,
  overall_uncertainty = TRUE,
  constant = NULL,
  fun = NULL,
  dist = 0.1,
  rug = TRUE,
  contour = TRUE,
  grouped_by = FALSE,
  ci_alpha = 0.2,
  ci_col = "black",
  smooth_col = "black",
  resid_col = "steelblue3",
  contour_col = "black",
  n_contour = NULL,
  partial_match = FALSE,
  discrete_colour = NULL,
  discrete_fill = NULL,
  continuous_colour = NULL,
  continuous_fill = NULL,
  position = "identity",
  angle = NULL,
  ncol = NULL,
  nrow = NULL,
  guides = "keep",
  widths = NULL,
  heights = NULL,
  crs = NULL,
  default_crs = NULL,
  lims_method = "cross",
  wrap = TRUE,
  caption = TRUE,
  envir = environment(formula(object)),
  ...
)
}
\arguments{
\item{object}{a fitted GAM, the result of a call to \code{\link[mgcv:gam]{mgcv::gam()}}.}

\item{data}{an optional data frame that is used to supply the data at which
the smooths will be evaluated and plotted. This is usually not needed, but
is an option if you need fine control over exactly what data are used for
plotting.}

\item{select}{character, logical, or numeric; which smooths to plot. If
\code{NULL}, the default, then all model smooths are drawn. Numeric \code{select}
indexes the smooths in the order they are specified in the formula and
stored in \code{object}. Character \code{select} matches the labels for smooths
as shown for example in the output from \code{summary(object)}. Logical
\code{select} operates as per numeric \code{select} in the order that smooths are
stored.}

\item{parametric}{logical; plot parametric terms also? Note that \code{select} is
used for selecting which smooths to plot. The \code{terms} argument is used to
select which parametric effects are plotted. The default, as with
\code{\link[mgcv:plot.gam]{mgcv::plot.gam()}}, is to not draw parametric effects.}

\item{terms}{character; which model parametric terms should be drawn? The
Default of \code{NULL} will plot all parametric terms that can be drawn.}

\item{residuals}{logical; should partial residuals for a smooth be drawn?
Ignored for anything but a simple univariate smooth.}

\item{scales}{character; should all univariate smooths be plotted with the
same y-axis scale? If \code{scales = "free"}, the default, each univariate
smooth has its own y-axis scale. If \code{scales = "fixed"}, a common y axis
scale is used for all univariate smooths.

Currently does not affect the y-axis scale of plots of the parametric
terms.}

\item{ci_level}{numeric between 0 and 1; the coverage of credible interval.}

\item{n}{numeric; the number of points over the range of the covariate at
which to evaluate the smooth.}

\item{n_3d}{numeric; the number of new observations to generate for the third
dimension of a 3D smooth.}

\item{n_4d}{numeric; the number of new observations to generate for the
dimensions higher than 2 (!) of a \emph{k}D smooth (\emph{k} >= 4). For example, if
the smooth is a 4D smooth, each of dimensions 3 and 4 will get \code{n_4d}
new observations.}

\item{unconditional}{logical; should confidence intervals include the
uncertainty due to smoothness selection? If \code{TRUE}, the corrected Bayesian
covariance matrix will be used.}

\item{overall_uncertainty}{logical; should the uncertainty in the model
constant term be included in the standard error of the evaluate values of
the smooth?}

\item{constant}{numeric; a constant to add to the estimated values of the
smooth. \code{constant}, if supplied, will be added to the estimated value
before the confidence band is computed.}

\item{fun}{function; a function that will be applied to the estimated values
and confidence interval before plotting. Can be a function or the name of a
function. Function \code{fun} will be applied after adding any \code{constant}, if
provided.}

\item{dist}{numeric; if greater than 0, this is used to determine when
a location is too far from data to be plotted when plotting 2-D smooths.
The data are scaled into the unit square before deciding what to exclude,
and \code{dist} is a distance within the unit square. See
\code{\link[mgcv:exclude.too.far]{mgcv::exclude.too.far()}} for further details.}

\item{rug}{logical; draw a rug plot at the bottom of each plot for 1-D
smooths or plot locations of data for higher dimensions.}

\item{contour}{logical; should contours be draw on the plot using
\code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}.}

\item{grouped_by}{logical; should factor by smooths be drawn as one panel
per level of the factor (\code{FALSE}, the default), or should the individual
smooths be combined into a single panel containing all levels (\code{TRUE})?}

\item{ci_alpha}{numeric; alpha transparency for confidence or simultaneous
interval.}

\item{ci_col}{colour specification for the confidence/credible intervals
band. Affects the fill of the interval.}

\item{smooth_col}{colour specification for the smooth line.}

\item{resid_col}{colour specification for the partial residuals.}

\item{contour_col}{colour specification for contour lines.}

\item{n_contour}{numeric; the number of contour bins. Will result in
\code{n_contour - 1} contour lines being drawn. See \code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}.}

\item{partial_match}{logical; should smooths be selected by partial matches
with \code{select}? If \code{TRUE}, \code{select} can only be a single string to match
against.}

\item{discrete_colour}{a suitable colour scale to be used when plotting
discrete variables.}

\item{discrete_fill}{a suitable fill scale to be used when plotting
discrete variables.}

\item{continuous_colour}{a suitable colour scale to be used when plotting
continuous variables.}

\item{continuous_fill}{a suitable fill scale to be used when plotting
continuous variables.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{angle}{numeric; the angle at which the x axis tick labels are to be
drawn passed to the \code{angle} argument of \code{\link[ggplot2:guide_axis]{ggplot2::guide_axis()}}.}

\item{ncol, nrow}{numeric; the numbers of rows and columns over which to
spread the plots}

\item{guides}{character; one of \code{"keep"} (the default), \code{"collect"}, or
\code{"auto"}. Passed to \code{\link[patchwork:plot_layout]{patchwork::plot_layout()}}}

\item{widths, heights}{The relative widths and heights of each column and
row in the grid. Will get repeated to match the dimensions of the grid. If
there is more than 1 plot and \code{widths = NULL}, the value of \code{widths} will
be set internally to \code{widths = 1} to accommodate plots of smooths that
use a fixed aspect ratio.}

\item{crs}{the coordinate reference system (CRS) to use for the plot. All
data will be projected into this CRS. See \code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}} for
details.}

\item{default_crs}{the coordinate reference system (CRS) to use for the
non-sf layers in the plot. If left at the default \code{NULL}, the CRS used is
4326 (WGS84), which is appropriate for spline-on-the-sphere smooths, which
are parameterized in terms of latitude and longitude as coordinates. See
\code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}} for more details.}

\item{lims_method}{character; affects how the axis limits are determined. See
\code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}}. Be careful; in testing of some examples, changing
this to \code{"orthogonal"} for example with the chlorophyll-a example from
Simon Wood's GAM book quickly used up all the RAM in my test system and the
OS killed R. This could be incorrect usage on my part; right now the grid
of points at which SOS smooths are evaluated (if not supplied by the user)
can produce invalid coordinates for the corners of tiles as the grid is
generated for tile centres without respect to the spacing of those tiles.}

\item{wrap}{logical; wrap plots as a patchwork? If \code{FALSE}, a list of
ggplot objects is returned, 1 per term plotted.}

\item{caption}{logical; show the smooth type in the caption of each plot?}

\item{envir}{an environment to look up the data within.}

\item{...}{additional arguments passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.}
}
\value{
The object returned is created by \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
}
\description{
Plots estimated smooths from a fitted GAM model in a similar way to
\code{mgcv::plot.gam()} but instead of using base graphics, \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
is used instead.
}
\note{
Internally, plots of each smooth are created using \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
and composed into a single plot using \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}. As a
result, it is not possible to use \code{+} to add to the plots in the way one
might typically work with \code{ggplot()} plots. Instead, use the \code{&} operator;
see the examples.
}
\examples{
load_mgcv()

# simulate some data
df1 <- data_sim("eg1", n = 400, dist = "normal", scale = 2, seed = 2)
# fit GAM
m1 <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = df1, method = "REML")

# plot all smooths
draw(m1)

# can add partial residuals
draw(m1, residuals = TRUE)

df2 <- data_sim("eg2", n = 1000, dist = "normal", scale = 1, seed = 2)
m2 <- gam(y ~ s(x, z, k = 40), data = df2, method = "REML")
draw(m2, contour = FALSE, n = 50)

# See https://gavinsimpson.github.io/gratia/articles/custom-plotting.html
# for more examples and for details on how to modify the theme of all the
# plots produced by draw(). To modify all panels, for example to change the
# theme, use the & operator
}
\author{
Gavin L. Simpson
}
