% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utililties.R
\name{model_constant}
\alias{model_constant}
\alias{model_constant.gam}
\alias{model_constant.gamlss}
\title{Extract the model constant term}
\usage{
model_constant(model, ...)

\method{model_constant}{gam}(model, lp = NULL, ...)

\method{model_constant}{gamlss}(model, ...)
}
\arguments{
\item{model}{a fitted model for which a \code{coef()} method exists.}

\item{...}{arguments passed to other methods.}

\item{lp}{numeric; which linear predictors to extract constant terms for.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Extracts the model constant term(s),
the model intercept, from a fitted model object.
}
\examples{
\dontshow{
op <- options(digits = 4)
}
load_mgcv()

# simulate a small example
df <- data_sim("eg1", seed = 42)

# fit the GAM
m <- gam(y ~ s(x0) + s(x1) + s(x2) + s(x3), data = df, method = "REML")

# extract the estimate of the constant term
model_constant(m)
# same as coef(m)[1L]
coef(m)[1L]

\dontshow{
options(op)
}
}
