% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family-utils.R
\name{link}
\alias{link}
\alias{link.family}
\alias{link.gam}
\alias{link.bam}
\alias{link.gamm}
\alias{link.glm}
\alias{inv_link}
\alias{inv_link.family}
\alias{inv_link.gam}
\alias{inv_link.bam}
\alias{inv_link.gamm}
\alias{inv_link.glm}
\title{Extract link and inverse link functions from models}
\usage{
link(object, ...)

\method{link}{family}(object, parameter = c("location", "scale", "shape"), ...)

\method{link}{gam}(object, parameter = c("location", "scale", "shape"), ...)

\method{link}{bam}(object, parameter = c("location", "scale", "shape"), ...)

\method{link}{gamm}(object, ...)

\method{link}{glm}(object, ...)

inv_link(object, ...)

\method{inv_link}{family}(object, parameter = c("location", "scale", "shape"), ...)

\method{inv_link}{gam}(object, parameter = c("location", "scale", "shape"), ...)

\method{inv_link}{bam}(object, parameter = c("location", "scale", "shape"), ...)

\method{inv_link}{gamm}(object, ...)

\method{inv_link}{glm}(object, ...)
}
\arguments{
\item{object}{a family object or a fitted model from which to extract the
family object.}

\item{...}{arguments passed to other methods.}

\item{parameter}{character; which parameter of the distribution. Usually
\code{"location"} but \code{"scale"} and \code{"shape"} may be provided for location
scale models.}
}
\description{
Returns the link or its inverse from an estimated model, and provides a
simple way to extract rhese functions from complex models with multiple
links, such as location scale models.
}
\examples{
load_mgcv()

link(gaussian())
link(nb())

inv_link(nb())

\dontshow{
set.seed(4234)
}
dat <- gamSim(1, n = 400, dist = "normal", scale = 2, verbose = FALSE)
mod <- gam(list(y ~ s(x0) + s(x1) + s(x2) + s(x3), ~ 1), data = dat,
           family = gaulss)

link(mod, parameter = "scale")
inv_link(mod, parameter = "scale")
}
\author{
Gavin L. Simpson
}
