% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth-estimates.R
\name{eval_smooth}
\alias{eval_smooth}
\alias{eval_smooth.mgcv.smooth}
\alias{eval_smooth.fs.interaction}
\alias{eval_smooth.random.effect}
\alias{eval_smooth.mrf.smooth}
\alias{eval_smooth.t2.smooth}
\alias{eval_smooth.tensor.smooth}
\title{S3 methods to evaluate individual smooths}
\usage{
eval_smooth(smooth, ...)

\method{eval_smooth}{mgcv.smooth}(
  smooth,
  model,
  n = 100,
  n_3d = NULL,
  n_4d = NULL,
  data = NULL,
  unconditional = FALSE,
  overall_uncertainty = TRUE,
  dist = NULL,
  ...
)

\method{eval_smooth}{fs.interaction}(
  smooth,
  model,
  n = 100,
  data = NULL,
  unconditional = FALSE,
  overall_uncertainty = TRUE,
  ...
)

\method{eval_smooth}{random.effect}(
  smooth,
  model,
  n = 100,
  data = NULL,
  unconditional = FALSE,
  overall_uncertainty = TRUE,
  ...
)

\method{eval_smooth}{mrf.smooth}(
  smooth,
  model,
  n = 100,
  data = NULL,
  unconditional = FALSE,
  overall_uncertainty = TRUE,
  ...
)

\method{eval_smooth}{t2.smooth}(
  smooth,
  model,
  n = 100,
  n_3d = NULL,
  n_4d = NULL,
  data = NULL,
  unconditional = FALSE,
  overall_uncertainty = TRUE,
  dist = NULL,
  ...
)

\method{eval_smooth}{tensor.smooth}(
  smooth,
  model,
  n = 100,
  n_3d = NULL,
  n_4d = NULL,
  data = NULL,
  unconditional = FALSE,
  overall_uncertainty = TRUE,
  dist = NULL,
  ...
)
}
\arguments{
\item{smooth}{currently an object that inherits from class \code{mgcv.smooth}.}

\item{...}{arguments assed to other methods}

\item{model}{a fitted model; currently only \code{\link[mgcv:gam]{mgcv::gam()}} and \code{\link[mgcv:bam]{mgcv::bam()}}
models are suported.}

\item{n}{numeric; the number of points over the range of the covariate at
which to evaluate the smooth.}

\item{n_3d}{numeric; the number of points over the range of last
covariate in a 3D or 4D smooth. The default is \code{NULL} which achieves the
standard behaviour of using \code{n} points over the range of all covariate,
resulting in \code{n^d} evaluation pointsm, where \code{d} is the dimension of the
smooth. For \code{d > 2} this can result in very many evaluation points and slow
performance. For smooths of \code{d > 4}, the value of \code{n_4d} will be used for
all dimensions \verb{> 4}, unless this is \code{NULL}, in which case the default
behaviour (using \code{n} for all dimensions) will be observed.}

\item{n_4d}{numeric; the number of points over the range of last
covariate in a 3D or 4D smooth. The default is \code{NULL} which achieves the
standard behaviour of using \code{n} points over the range of all covariate,
resulting in \code{n^d} evaluation pointsm, where \code{d} is the dimension of the
smooth. For \code{d > 2} this can result in very many evaluation points and slow
performance. For smooths of \code{d > 4}, the value of \code{n_4d} will be used for
all dimensions \verb{> 4}, unless this is \code{NULL}, in which case the default
behaviour (using \code{n} for all dimensions) will be observed.}

\item{data}{an optional data frame of values to evaluate \code{smooth} at.}

\item{unconditional}{logical; should confidence intervals include the
uncertainty due to smoothness selection? If \code{TRUE}, the corrected Bayesian
covariance matrix will be used.}

\item{overall_uncertainty}{logical; should the uncertainty in the model
constant term be included in the standard error of the evaluate values of
the smooth?}

\item{dist}{numeric; if greater than 0, this is used to determine when
a location is too far from data to be plotted when plotting 2-D smooths.
The data are scaled into the unit square before deciding what to exclude,
and \code{dist} is a distance within the unit square. See
\code{\link[mgcv:exclude.too.far]{mgcv::exclude.too.far()}} for further details.}
}
\description{
S3 methods to evaluate individual smooths
}
