% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misssbm.R
\docType{class}
\name{misssbm-class}
\alias{misssbm-class}
\title{Stochastic Block Model with sampling scheme class}
\description{
An S4 class to represent a Stochastic Block Model with a sampling scheme for missing data, extend \code{\link{icl_model-class}}. 
Such model can be used to cluster graph vertex, and model a square adjacency matrix \eqn{X} with the following generative model :  
\deqn{ \pi \sim Dirichlet(\alpha)}
\deqn{ Z_i  \sim \mathcal{M}(1,\pi)}
\deqn{ \theta_{kl} \sim Beta(a_0,b_0)}
\deqn{ X_{ij}|Z_{ik}Z_{jl}=1 \sim \mathcal{B}(\theta_{kl})}
Missing value are supposed to be generated afterwards, the observation process correspond to a binary matrix \eqn{R} of the same size as \eqn{X}, 
with \eqn{R_{ij}=1} for observed entries and \eqn{R_{ij}=0} for missing ones. \eqn{R} may be supposed to be MAR:
\deqn{ \epsilon \sim Beta(a_{0obs},b_{0obs})}
\deqn{ R_{ij} \sim \mathcal{B}(\epsilon)}
this correspond to the "dyad" sampling scheme. But the sampling scheme can also be NMAR:
\deqn{ \epsilon_{kl} \sim Beta(a_{0obs},b_{0obs})}
\deqn{ R_{ij}|Z_{ik}Z_{jl}=1 \sim \mathcal{B}(\epsilon_{kl})}
this correspond to the "block-dyad" sampling scheme.
This class mainly store the prior parameters value \eqn{\alpha,a_0,b_0,a_{0obs},b_{0obs}} of this generative model in the following slots:
}
\section{Slots}{

\describe{
\item{\code{name}}{name of the model}

\item{\code{alpha}}{Dirichlet over cluster proportions prior parameter (default to 1)}

\item{\code{a0}}{Beta prior parameter over links (default to 1)}

\item{\code{b0}}{Beta prior parameter over no-links (default to 1)}

\item{\code{type}}{define the type of networks (either "directed" or "undirected", default to "directed")}

\item{\code{sampling}}{define the sampling process (either "dyad" or "block-dyad" )}

\item{\code{sampling_priors}}{define the sampling process priors parameters (list with \code{a0obs} and \code{b0obs} fields.)}
}}

\examples{
new("misssbm")
new("misssbm",a0=0.5, b0= 0.5,alpha=0.5,sampling="dyad",sampling_priors=list(a0obs = 2,b0obs = 1))
sbm = rsbm(100,c(0.5,0.5),diag(2)*0.1+0.01)
sbm$x[cbind(base::sample(1:100,50),base::sample(1:100,50))]=NA
sol = greed(sbm$x,model=new("misssbm",sampling="dyad"))
}
\references{
Nowicki, Krzysztof and Tom A B Snijders (2001). “Estimation and prediction for stochastic block structures”. In:Journal of the American statistical association 96.455, pp. 1077–1087
}
\seealso{
\code{\link{misssbm_fit-class}},\code{\link{misssbm_path-class}}

\code{\link{greed}}
}
