% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_stdf.R
\name{stdf}
\alias{stdf}
\alias{stdf.Network}
\alias{stdf.HRMtree}
\alias{stdf.HRMBG}
\title{Stable tail dependence function (stdf)}
\usage{
stdf(obj, ...)

\method{stdf}{Network}(obj, Y, k_ratio, ...)

\method{stdf}{HRMtree}(obj, x, Ubar = NULL, ...)

\method{stdf}{HRMBG}(obj, x, Ubar = NULL, ...)
}
\arguments{
\item{obj}{Object of class \code{Network}, or \code{HRMtree} or \code{HRMBG}}

\item{...}{additional arguments}

\item{Y}{A matrix of evaluation points with columns named according to the names of the nodes with
observed variables,
and of dimensions qx|U| where U is the set of observed variables, and q is the number of vectors at which the
stdf is evaluated.}

\item{k_ratio}{the ration of the upper order statistics as a share of the size of the sample}

\item{x}{Vector of evaluation points with named elements according to the nodes of the graph.}

\item{Ubar}{The set of nodes for which data are missing. It should stay at its default value NULL.}
}
\value{
A scalar representing the value of the stdf.
}
\description{
Computes the stable tail dependence function for given coordinates. If object of class \code{Network} or
 its subclasses is passed
non-parametric estimates of the stdf are computed. If an object of class \code{HRMtree} or \code{HRMBG} is passed
parametric estimates are computed with parameters that constitute the slot \code{$depParams} in the object.
}
\examples{
#See Vignette "Additional functionalities".
}
