% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_combine.R
\name{combine}
\alias{combine}
\alias{combine.Set}
\title{Combines objects}
\usage{
combine(obj, ...)

\method{combine}{Set}(obj, ...)
}
\arguments{
\item{obj}{Object of class \code{Set}}

\item{...}{lists that are going to be combined}
}
\value{
An object of class \code{RootDepSet} with two slots \code{$value} which contains subsets on the node set
and slot \code{$root} containing the respective roots for ecevy subset.
}
\description{
It is designed to combine objects from classes \code{RootDepSet} for instance an object of class
\code{Neighborhood} and an object of class \code{FlowConnect}. For instance if for in one of the objects
we have root \eqn{a} with subset \eqn{(a,b,c)} and in the second object for root \eqn{a} we have subset
\eqn{(a,b,d,e)} then
applying \code{combine} will create for root \eqn{a} a subset \eqn{(a,b)}.
}
\examples{
# using two sets of class \code{RootDepSet}
rds1<- RootDepSet()
rds1<- setRootDepSet(rds1, list(a=letters[1:3], b=letters[1:4]), root=c("a", "b"))
rds2<- RootDepSet()
rds2<- setRootDepSet(rds2, list(a=letters[1:7], c=letters[2:5]), root=c("a", "c"))
myset<- Set()
combine(myset, rds1, rds2)

# using lists with structure that imitates the one of class RootDepSet
list1<- list(value=list(a=letters[1:5], b=letters[1:4]), root=NULL)
list2<- list(value=list(a=letters[1:7], b=letters[2:5]), root=NULL)
myset<- Set()
combine(myset, list1, list2)
}
