% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_extrCoeff.R
\name{extrCoeff}
\alias{extrCoeff}
\alias{extrCoeff.Network}
\alias{extrCoeff.HRMtree}
\alias{extrCoeff.HRMBG}
\title{Calculates extremal coefficients}
\usage{
extrCoeff(obj, ...)

\method{extrCoeff}{Network}(obj, k_ratio, v = NULL, ...)

\method{extrCoeff}{HRMtree}(obj, v = NULL, ...)

\method{extrCoeff}{HRMBG}(obj, v = NULL, ...)
}
\arguments{
\item{obj}{If it is an object of class \code{Network} non-parametric estimates are computed.
If it is an object of class \code{HRMtree}, parametric EC are computed.
If object of class \code{HRMBG} is passed, parametric EC are computed.}

\item{...}{additional arguments}

\item{k_ratio}{is the number of upper order statistics divided by the total number of observations.}

\item{v}{a vector of length the number of nodes and named according to the names of the nodes.
NULL by default. See Details.}
}
\value{
Either a scalar for the value of the extremal coefficient or a matrix of pairwise extremal coefficients.
If the argument \code{v} is NULL then it returns a matrix of pairwise extremal coefficients.
}
\description{
Computes parametric and non-parametric extremal coefficients. For explanation of extremal coefficients
see Vignette "Additional functionalities".
}
\details{
If the vector \code{v} is  non NULL then an extremal
coefficient is computed based on the vector \code{v}. This means for instance that if \code{v} is
(0, 1, 0, 2.5, 1.8) with names \eqn{(a,b,c,d, e)} then a trivariate extremal coefficient is computed taking
coordinates \eqn{(b,d,e)} to be equal to 1. If the vector \code{v} is NULL, then bivariate extremal coefficients are
computed and ordered in a matrix of pairwise extremal coefficients.
}
\examples{
# bivariate extremal coefficients of a tree model
g<- graph(c(1, 2, 2, 3, 2, 4), directed = FALSE)
g<- set.vertex.attribute(g, "name", V(g), c("a", "b", "c", "d"))
obj<- HRMtree(g)
obj<- setParams(obj, c(0.2, 0.3, 0.4))
extrCoeff(obj)
# arbitrary vector of coordinates
v<- c(1,2,0,6); names(v)<- c("a", "b", "c", "d")
extrCoeff(obj, v)

# non-parametric extremal coefficients
data<- matrix(rnorm(4 * 500), 500, 4)
colnames(data)<- c("a" , "b", "c", "d")
tobj<- Tree(g, data)
extrCoeff(tobj, 0.2)
# arbitrary vector of coordinates
v<- c(1, 2, 0, 6); names(v)<- c("a", "b", "c", "d")
extrCoeff(tobj, k_ratio = 0.2, v = v)

#bivariate extremal coefficients of a block graph model
g<- graph(c(1, 2, 2, 3, 1, 3, 3, 4, 4, 5, 3, 5), directed = FALSE)
g<- set.vertex.attribute(g, "name", V(g), c("a", "b", "c", "d", "e"))
obj<- HRMBG(g)
obj<- setParams(obj, c(0.2, 0.3, 0.4, 0.5, 0.6, 0.1))
extrCoeff(obj)
# arbitrary vector of coordinates
v<- c(1, 1, 0, 1, 1); names(v)<- c("a", "b", "c", "d", "e")
extrCoeff(obj, v)
}
