% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr_rHRM.R
\name{rHRM}
\alias{rHRM}
\alias{rHRM.HRMnetwork}
\alias{rHRM.HRMBG}
\title{Generates random sample}
\usage{
rHRM(obj, ...)

\method{rHRM}{HRMnetwork}(obj, n, noise = FALSE, ...)

\method{rHRM}{HRMBG}(obj, lambda, n, noise = FALSE, ...)
}
\arguments{
\item{obj}{Object of class \code{HRMnetwork} or its subclasses such as \code{HRMtree} and \code{HRMBG} or
subclasses of these two. If no explicit method exists the method \code{rHRM.HRMnetwork} is called.}

\item{...}{additional arguments}

\item{n}{The size of the sample}

\item{noise}{TRUE/FALSE indicates whether to include (TRUE) a standard normal noise
to all observations in the sample. The default is FALSE.}

\item{lambda}{is a structured parameter matrix of the Huesler-Reiss distribution. See Vignette
"Huesler-Reiss distributions" parameterization on block graphs.}
}
\value{
A matrix with the generated observations.
}
\description{
If the method is called on object of class \code{HRMtree} it generates a random sample from
a Markov tree whose every two adjacent nodes are parameterized
with a bivariate Huesler-Reiss distribution with parameter the weight associated to the edge connecting the
two variables. Markov tree means that the random vector satisfies the global Markov property.
See Vignette "Additional functionalities" for further explanation of the distribution from which it is sampled.
If the method is called on an object of class \code{HRMBG} then it generates a random sample from a
Huesler-Reiss distribution with structured parameter matrix.
See Vignette "Additional functionalities" for further explanation of the distribution from which it is sampled.
See Vignette "Huesler-Reiss distributions" for the parameterization on block graphs.
}
\examples{
# create a graph with named vertices
g<- graph(c("a", "b", "b","c", "b", "d"), directed = FALSE)
# create a HRMtree object
myobj<- HRMtree(g)
x<- c(0.1,0.2,0.3)
myobj<- setParams(myobj, x)
# create a dataset
mydata<- rHRM(myobj, 1000)
mydata_noisy<- rHRM(myobj, 1000, noise=TRUE)
}
