% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covFun.R
\name{covFun}
\alias{covFun}
\alias{stTrans}
\alias{conTrans}
\alias{vech2matlist}
\alias{start2theta}
\alias{matlist2vech}
\alias{theta2nu_trans}
\alias{nu2theta_trans}
\alias{theta2nu_lambda}
\alias{nu2theta_lambda}
\alias{nuVar2thetaVar_lambda}
\alias{nuAI2thetaAIinv_lambda}
\alias{nu2theta_noTrans}
\title{(Co)variance parameter transformations.}
\usage{
stTrans(x)

conTrans(Gcon, Rcon)

start2theta(Gstart, Rstart, name = NULL)

matlist2vech(theta)

vech2matlist(vech, skeleton)

theta2nu_trans(theta)

nu2theta_trans(nu)

theta2nu_lambda(theta, thetaG, thetaR)

nu2theta_lambda(nu, sigma2e, thetaG, thetaR)

nuVar2thetaVar_lambda(object)

nuAI2thetaAIinv_lambda(object)

nu2theta_noTrans(nu, thetaG, thetaR)
}
\arguments{
\item{x, theta, nu}{A \code{list} of matrices containing the (co)variance
parameters of the model.}

\item{Gcon, Rcon}{A \code{list} of starting (co)variance constraints for the
G-structure (random effects terms) or R-structure (residual).}

\item{Gstart, Rstart}{A \code{list} of starting (co)variance values for the
G-structure (random effects terms) or R-structure (residual).}

\item{name}{An (optional) character \code{vector} containing the (co)variance
component names.}

\item{vech}{A \code{vector} of (co)variance parameters.}

\item{skeleton}{An example structure to map \code{vech} onto.}

\item{thetaG, thetaR}{A \code{vector} indexing the G-structure or R-structure
components, respectively.}

\item{sigma2e}{A \code{numeric} estimate of the factored out residual
variance from the mixed model equations (i.e., the \sQuote{lambda} scale)
\eqn{\sigma^{2}_{e}}.}

\item{object}{An object of \code{class} \sQuote{gremlin}.}
}
\value{
Functions are specified to mostly return either a \code{list} of
  matrices (structure as defined by the \dQuote{skel} attribute or in
  the \code{skeleton} object) or a \code{vector} containing the (co)variance
  parameters of the model. Additional list elements returned can be:
  \describe{
    \item{thetaG }{A \code{vector} indexing the G-structure components.}
    \item{thetaR }{A \code{vector} indexing the R-structure components.}
  }
  Alternatively, \code{nuVar2thetaVar_lambda} and \code{nuAI2thetaAIinv_lambda}
  return a \code{vector} and \code{matrix}, respectively, holding the sampling
  (co)variances of the model (co)variance parameters both on the \code{theta}
  scale. These are elements of the inverse Average Information matrix.
}
\description{
Converts lists of (co)variance parameters either between \code{list} and 
  \code{vector} format or between the theta and nu scales.
}
\details{
\itemize{
  \item{\code{stTrans} }{Transform start parameters into lower triangle
    matrices of class \code{dsCMatrix}.}
  \item{\code{conTrans} }{Transformation of starting constraints to correct
    format.}
  \item{\code{start2theta} }{Converts lists of starting values for (co)variance
    parameters to a theta object used to structure the (co)variance components
    within gremlin.}
  \item{\code{matlist2vech} }{Converts a \code{list} of (co)variance parameter
    matrices to a vector with a \dQuote{skel} attribute.}
  \item{\code{vech2matlist} }{Converts a vector of (co)variance parameters to
    a list of covariance matrices.}
  \item{\code{theta2nu_trans} }{Transforms theta to nu scale by taking the
    Cholesky factor of each covariance matrix and then replacing the diagonals
    with  their (natural) logarithms. Done to ensure matrices are positive
    definite.}
  \item{\code{nu2theta_trans} }{Back transformation from
    \code{theta2nu_trans}: exponentiates the diagonal elements of each matrix
    then calculates the cross-product.}
  \item{\code{theta2nu_lambda} }{Transformation that factors out a residual
    variance so that \code{nu} contains the \sQuote{lambda} parameterization:
    ratios of variance parameters with the residual variance.}
  \item{\code{nu2theta_lambda} }{Back transformation from
    \code{theta2nu_lambda}.}
  \item{\code{nuVar2thetaVar_lambda} }{Transformation of Sampling Variances
    from \code{lambda} Scale for \code{theta}.}
  \item{\code{nuAI2thetaAIinv_lambda} }{Transform AI matrix from \code{lambda}
    Scale to AI-inverse of \code{theta}.}
  \item{\code{nu2theta_noTrans} }{Structures \code{theta} when not
    transformed.}
}
}
\examples{
  # User-specified starting parameters
  thetaOut <- start2theta(Gstart = list(matrix(1), matrix(2)),
    Rstart = matrix(3))
  ## convert to a vector and then back into a matrix list
  thetav <- matlist2vech(thetaOut$theta)
  theta <- vech2matlist(thetav, attr(thetav, "skel"))
    identical(thetaOut$theta, theta)  #<-- should be TRUE
  # lambda parameterization transformation
  nu <- theta2nu_lambda(theta, thetaOut$thetaG, thetaOut$thetaR)
  # back-transform from (lambda scale) nu to theta
  ## For example, when the sigma2e estimate=0.5
  theta2 <- nu2theta_lambda(nu, sigma2e = 0.5, thetaOut$thetaG, thetaOut$thetaR)
}
\author{
\email{matthewwolak@gmail.com}
}
