% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/censored.R
\name{normal_censored}
\alias{normal_censored}
\title{Normal Censored Distribution}
\usage{
normal_censored(
  mean,
  sd,
  is_censored,
  censor = "right",
  lower = NULL,
  upper = NULL,
  dim = length(is_censored)
)
}
\arguments{
\item{mean}{Mean of the normal distribution.}

\item{sd}{Standard deviation of the normal distribution.}

\item{is_censored}{Logical vector indicating whether each observation is censored.}

\item{censor}{Type of censoring: one of 'right', 'left', 'interval'.}

\item{lower}{Lower bound for interval censoring (optional).}

\item{upper}{Upper bound for interval censoring (optional).}

\item{dim}{Dimension of the data (optional, defaults to length of \code{mean}).}
}
\value{
A greta censored normal distribution node.
}
\description{
Creates a censored normal distribution for use with greta.
}
