% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_linear_forest.R
\name{predict.local_linear_forest}
\alias{predict.local_linear_forest}
\title{Predict with a local linear forest}
\usage{
\method{predict}{local_linear_forest}(object, newdata = NULL,
  linear.correction.variables = NULL, ll.lambda = NULL,
  ll.ridge.type = "standardized", num.threads = NULL, ...)
}
\arguments{
\item{object}{The trained forest.}

\item{newdata}{Points at which predictions should be made. If NULL,
makes out-of-bag predictions on the training set instead
(i.e., provides predictions at Xi using only trees that did
not use the i-th training example).}

\item{linear.correction.variables}{Optional subset of indexes for variables to be used in local
linear prediction. If left NULL, all variables are used.
We run a locally weighted linear regression on the included variables.
Please note that this is a beta feature still in development, and may slow down
prediction considerably. Defaults to NULL.}

\item{ll.lambda}{Ridge penalty for local linear predictions}

\item{ll.ridge.type}{Option to standardize ridge penalty by covariance ("standardized"),
or penalize all covariates equally ("identity").}

\item{num.threads}{Number of threads used in training. If set to NULL, the software
automatically selects an appropriate amount.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A vector of predictions.
}
\description{
Gets estimates of E[Y|X=x] using a trained regression forest.
}
\examples{
\dontrun{
# Train the forest.
n = 50; p = 5
X = matrix(rnorm(n*p), n, p)
Y = X[,1] * rnorm(n)
forest = local_linear_forest(X, Y)

# Predict using the forest.
X.test = matrix(0, 101, p)
X.test[,1] = seq(-2, 2, length.out = 101)
predictions = predict(forest, X.test)

# Predict on out-of-bag training samples.
predictions.oob = predict(forest)
}

}
