% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.grf_tree}
\alias{plot.grf_tree}
\title{Plot a GRF tree object.}
\usage{
\method{plot}{grf_tree}(x, include.na.path = NULL, ...)
}
\arguments{
\item{x}{The tree to plot}

\item{include.na.path}{A boolean toggling whether to include the path of missing values or not.
It defaults to whether the forest was trained with NAs.}

\item{...}{Additional arguments (currently ignored).}
}
\description{
The direction NAs are sent are indicated with the arrow fill. An empty arrow indicates
that NAs are sent that way. If trained without missing values, both arrows are filled.
}
\examples{
\dontrun{
# Plot a tree in the forest (requires the `DiagrammeR` package).
n <- 500
p <- 10
X <- matrix(rnorm(n * p), n, p)
W <- rbinom(n, 1, 0.5)
Y <- pmax(X[, 1], 0) * W + X[, 2] + pmin(X[, 3], 0) + rnorm(n)
c.forest <- causal_forest(X, Y, W)
plot(tree <- get_tree(c.forest, 1))
# Saving a plot in .svg can be done with the `DiagrammeRsvg` package.
install.packages("DiagrammeRsvg")
tree.plot = plot(tree)
cat(DiagrammeRsvg::export_svg(tree.plot), file = 'plot.svg')
}
}
