% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_gamma.R
\name{update_gamma}
\alias{update_gamma}
\title{Update Gamma}
\usage{
update_gamma(k, theta, priors = list(), alternate_priors = FALSE)
}
\arguments{
\item{k}{Double value for \eqn{k} (total revenue generating events). Must be 0 or greater.}

\item{theta}{Double value for \eqn{\theta} (sum of revenue). Must be 0 or greater.}

\item{priors}{An optional list object that contains k0 and
theta0. Otherwise the function will use \eqn{Gamma(1,250)} as the prior distribution.
If a second gamma distribution is used k01 and theta01 can be defined as separate priors
when alternate_priors is set to TRUE.}

\item{alternate_priors}{Boolean Defaults to FALSE. Allows a user to specify alternate
prior names so the same prior isn't required when multiple gamma distributions are used.}
}
\value{
A list object that contains `k` and `theta`
}
\description{
Updates Gamma Distribution with the Gamma-Exponential
conjugate prior update rule. Parameterized by \eqn{k} and \eqn{\theta} (not \eqn{\alpha, \beta})
}
\examples{
update_gamma(k = 1, theta = 100, priors = list(k0 = 2, theta0 = 1000))
update_gamma(k = 10, theta = 200)

}
