% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view.R
\name{view_grob}
\alias{view_grob}
\title{View Grob}
\usage{
view_grob(grob, height = NA_real_, width = NA_real_)
}
\arguments{
\item{grob}{An object outputted by one of the following functions:
\itemize{

\item \code{\link{grob_matrix}}
\item \code{\link{grob_image}}
\item \code{\link{grob_row}}
\item \code{\link{grob_col}}
\item \code{\link{grob_layout}}

}}

\item{height}{The numeric height in millimeters the user wishes to view the grob in.}

\item{width}{The numeric width in millimeters the user wishes to view the grob in.}
}
\description{
View an grob outputted by one of the \code{grob_} functions with a given width and
height.
}
\details{
Plotted with \code{\link[gridExtra:arrangeGrob]{gridExtra::grid.arrange()}}.
}
\examples{

df = data.frame(
  x = c(15, 4, 16, 11),
  y = c(10, 30, 3, 10)
  ) 
  
df \%>\%
  grob_matrix() \%>\%
  view_grob()
  
gg = ggplot2::ggplot(data = df, mapping = ggplot2::aes(x = x, y = y)) +
  ggplot2::geom_line(color = 'red')
  
gg \%>\%
  grob_image() \%>\%
  view_grob()

}
