% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gp_informative_compare_plot.R
\name{informative_plot}
\alias{informative_plot}
\title{Plot credible intervals for parameters to compare ignoring with weighting an informative sample}
\usage{
informative_plot(
  objects = NULL,
  objects_labels = c("ignore", "weight"),
  map = NULL,
  units_name = NULL,
  model = "gp",
  true_star = NULL,
  map_true = NULL
)
}
\arguments{
\item{objects}{A list of objects, either all outputs from gpdpgrow(), or all from gmrfdpgrow().
\code{objects} includes a model estimated under ignoring the informativeness of the 
sampling design and another that employs weighting to account for the informativeness.
An additional object may be added to represent a separate "iid" (or non-informative)
sample from the same population, which will typically be available if the dataset
was generated as synthetic data using function, "gen_informative_sample()".}

\item{objects_labels}{A character vector of length equal to \code{objects} that provides
labels for each entry in \code{objects}.  Allowed entries in \code{objects_labels} 
are \code{c("ignore","weight","iid")}, where "ignore" denotes a model that ignores
the informativeness, while "weight" denotes a model that employs sampling weights and
"iid" denotes a model run on a non-informative, iid sample from the same population.
Defaults to \code{objects_labels = c("ignore","weight")}.}

\item{map}{A list matrices, where each entry is produced 
from \code{cluster_plot(object)$map}. It is comprised of
unit labels and cluster assignments for each object in \code{objects}.
The length of \code{map} must be equal to the length of \code{objects}.}

\item{units_name}{The label in each "map" matrix for the observation units. Will be the same as the
\code{units_name} entry for the previously run, \code{cluster_plot()} function.}

\item{model}{A scalar character input indicating the estimation model for \emph{all} of the entries
in \code{objects}. Allowable values for \code{model} are c("gp","gmrf"). Defaults to
\code{model = "gp"}.}

\item{true_star}{An optional, \emph{P x M}  matrix, of true parameter location values, where
\code{P} denotes the number of parameters per cluster and \code{M} denotes the number of
clusters.  For example, in \code{model = "gp"} with a single, rational quadratic covariance,
\code{P = 3} and if there are 3 clusters, then \code{M = 3}.  For a \code{model = "gmrf"},
with a single covariance, \code{P = 1}.}

\item{map_true}{An optional \code{data.frame} object with \code{n} rows, the size of the
informative sample used for \code{c("ignore","weight")} objects that maps the
\code{units_name} to a true cluster.  \code{map_true} must have 2 columns (and the
rest are ignored), one must be named the same value as input for \code{units_name}.
The second column must be named, \code{cluster}.  If the true values derive
from running \code{gen_informative_sample()} as the source of the true values,
one may just input the \code{map_obs} \code{data.frame} that is listed in the object
returned by \code{gen_informative_sample()}.}
}
\value{
A list object containing the plot of estimated functions, faceted by cluster,
    	and the associated \code{data.frame} object.
    \item{p.compare}{A \code{ggplot2} plot object}
    \item{dat.compare}{A \code{data.frame} object used to generate \code{p.compare}.}
}
\description{
Uses as input the output object from the gpdpgrow() and gmrfdpgrow() functions.
}
\examples{
\dontrun{
library(growfunctions)
## use gen_informative_sample() to generate an 
## N X T population drawn from a dependent GP
## By default, 3 clusters are used to generate 
## the population.
## A single stage stratified random sample of size n 
## is drawn from the population using I = 4 strata. 
## The resulting sample is informative in that the 
## distribution for this sample is
## different from the population from which 
## it was drawn because the strata inclusion
## probabilities are proportional to a feature 
## of the response, y (in the case, the variance.
## The stratified random sample over-samples 
## large variance strata).
## (The user may also select a 2-stage 
## sample with the first stage
## sampling "blocks" of the population and 
## the second stage sampling strata within blocks). 
dat_sim        <- gen_informative_sample(N= 10000, 
                                n = 500, T = 5,
                                noise_to_signal = 0.1)

y_obs                       <- dat_sim$y_obs
T                           <- ncol(y_obs)

an informative sampling design that inputs inclusion
probabilities, ipr
res_gp_w            <- gpdpgrow(y = y_obs, 
                               ipr = dat_sim$map_obs$incl_prob, 
                               n.iter = 5, n.burn = 2,  
                               n.thin = 1, n.tune = 0)
and fit vs. data for experimental units
fit_plots_w         <- cluster_plot( object = res_gp_w,  
                           units_name = "establishment", 
                           units_label = dat_sim$map_obs$establishment, 
                           single_unit = FALSE, credible = TRUE )

## estimate parameters ignoring sampling design
res_gp_i            <- gpdpgrow(y = y_obs, 
                               n.iter = 5, n.burn = 2, 
                               n.thin = 1, n.tune = 0)
## plots of estimated functions, faceted by cluster and fit vs. 
## data for experimental units
fit_plots_i         <- cluster_plot( object = res_gp_i,  
                                    units_name = "establishment", 
                                    units_label = dat_sim$map_obs$establishment, 
                                    single_unit = FALSE, credible = TRUE )

## We also draw an iid (non-informative, exchangeable) 
## sample from the same population to 
## compare estimation results to our weighted 
## (w) and unweighted/ignoring (i) models

## estimate parameters under an iid sampling design
res_gp_iid          <- gpdpgrow(y = dat_sim$y_iid, 
                               n.iter = 5, n.burn = 2,   
                               n.thin = 1, n.tune = 0)
## plots of estimated functions, faceted by cluster and 
## fit vs. data for experimental units
fit_plots_iid       <- cluster_plot( object = res_gp_iid,  
                           units_name = "establishment", 
                           units_label = dat_sim$map_iid$establishment, 
                           single_unit = FALSE, credible = TRUE )

## compare estimations of covariance parameter credible 
## intervals when ignoring informativeness vs.
## weighting to account for informativeness
objects                  <- map <- vector("list",3)
objects[[1]]             <- res_gp_i
objects[[2]]             <- res_gp_iid
objects[[3]]             <- res_gp_w
map[[1]]                 <- fit_plots_i$map
map[[2]]                 <- fit_plots_iid$map
map[[3]]                 <- fit_plots_w$map
objects_labels           <- c("ignore","iid","weight")

parms_plots_compare      <- informative_plot( objects = objects, 
                                objects_labels = objects_labels,
                                map = map, units_name = "establishment", 
                                model = "gp",
                                true_star = dat_sim$theta_star, 
                                map_true = dat_sim$map_obs)

}
}
\seealso{
\code{\link{gpdpgrow}}, \code{\link{gmrfdpgrow}}
}
\author{
Terrance Savitsky \email{tds151@gmail.com}
}
