% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\docType{methods}
\name{plot}
\alias{plot}
\alias{plot,nonlinear_fit,missing-method}
\alias{lines,nonlinear_fit-method}
\alias{plot,easylinear_fit,missing-method}
\alias{plot,smooth.spline_fit,missing-method}
\alias{lines,easylinear_fit-method}
\alias{plot,multiple_fits,missing-method}
\title{Plot Model Fits}
\usage{
\S4method{plot}{nonlinear_fit,missing}(x, y, log = "", which = c("fit",
  "diagnostics"), ...)

\S4method{lines}{nonlinear_fit}(x, ...)

\S4method{plot}{easylinear_fit,missing}(x, y, log = "",
  which = c("fit", "diagnostics"), ...)

\S4method{plot}{smooth.spline_fit,missing}(x, y, ...)

\S4method{lines}{easylinear_fit}(x, ...)

\S4method{plot}{multiple_fits,missing}(x, y, ...)
}
\arguments{
\item{x}{an object returned by a model fitting function of package
\pkg{growthrates}, that can contain one or multiple fits.}

\item{y}{(ignored) for compatibility with the default plot method.}

\item{log}{a character string which contains \code{"y"} if the y axis is to
be logarithmic.}

\item{which}{either \code{"fit"} (default) or \code{"diagnostics"}.}

\item{\dots}{other arguments pased to the plotting methods,
see \code{\link{plot.default}} and \code{\link{par}}.}
}
\description{
Methods to plot growth model fits together with the data and, alternatively,
plot diagnostics
}
\details{
The plot methods detect automatically which type of plot is
  appropriate, depending on the class of \code{x} and can plot either one
  single model fit or a complete series (multiple fits). In the latter case
  it may be wise to redirect the graphics to an external file (e.g. a pdf)
  and / or to use tomething like \code{par(mfrow=c(3,3))}.

  The \code{lines}-method is currently only available for single fits.

  If you need more control, you can of course also write own plotting functions.
}
\examples{

data(bactgrowth)
splitted.data <- multisplit(bactgrowth, c("strain", "conc", "replicate"))

## get table from single experiment
dat <- splitted.data[["D:0:1"]]

fit1 <- fit_spline(dat$time, dat$value)
plot(fit1, log="y")
plot(fit1)

## derive start parameters from spline fit
p <- coef(fit1)

## subset of first 10 data
first10 <-  dat[1:10, ]
fit2 <- fit_growthmodel(grow_exponential, p=p, time=first10$time, y=first10$value)

p <- c(coef(fit1), K = max(dat$value))
fit3 <- fit_growthmodel(grow_logistic, p=p, time=dat$time, y=dat$value, transform="log")

plot(fit1)
lines(fit2, col="green")
lines(fit3, col="red")


all.fits <- all_splines(value ~ time | strain + conc + replicate, data = bactgrowth)
par(mfrow=c(3,3))
plot(all.fits)

## it is also possible to plot a single fit or a subset of the fits
par(mfrow=c(1,1))
plot(all.fits[["D:0:1"]])
par(mfrow=c(2,2))
plot(all.fits[1:4])

## plot only the 'R' strain
par(mfrow=c(4, 6))
plot(all.fits[grep("R:", names(all.fits))])

}
\seealso{
\code{\link{plot.default}}, \code{\link{par}},
  \code{\link{fit_growthmodel}}, \code{\link{fit_easylinear}},
  \code{\link{all_growthmodels}}, \code{\link{all_easylinear}}
}
