% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{gr_plot_minmonth}
\alias{gr_plot_minmonth}
\title{Plot minimum runoff month}
\usage{
gr_plot_minmonth(
  df,
  year = NULL,
  exclude = NULL,
  tests = NULL,
  pagebreak = FALSE,
  print = TRUE
)
}
\arguments{
\item{df}{\code{data.frame} of hydrograph and meteorological variables as produced by \code{\link[=gr_summarize]{gr_summarize()}}.}

\item{year}{Integer. Change year value to separate two periods.}

\item{exclude}{Integer vector of years to be excluded from plotting.}

\item{tests}{Tests list for the same variables (generated by \code{\link[=gr_test_vars]{gr_test_vars()}} function)}

\item{pagebreak}{Logical. Whether to break page between plots (needed for reporting). Defaults to \code{FALSE}.}

\item{print}{Boolean. Print plot? Defaults to \code{TRUE}. Use \code{FALSE} if you want to tweak the plot aesthetics before plotting.}
}
\value{
\code{list} of two \code{ggplot2} objects, representing the histogram of a minimum runoff month for two periods: before and after the change year
}
\description{
Generate a histogram of a minimum runoff month for two periods: before and after the change year set by \code{year} parameter.
}
\examples{\donttest{
library(grwat)

data(spas) # example Spas-Zagorye data is included with grwat package

# separate
sep = gr_separate(spas, params = gr_get_params(reg = 'center'))

# summarize
vars = gr_summarize(sep)

# plot minimum runoff month for two periods divided by Pettitt test
gr_plot_minmonth(vars, tests = gr_test_vars(vars))

# plot minimum runoff month for two periods divided by fixed year
gr_plot_minmonth(vars, year = 1978)
}}
