#'
#'
#' A gene set list containing multiple human GO gene sets
#'
#' @format A list
#' @source {created based on msigdbr human C5 (biological process) gene sets}
#' @examples
#' data(gene.set.list)       #Lazy loading. Data becomes visible as soon as called
"gene.set.list"

#'
#'
#' cell embeddings for pbmc3k data
#'
#' @format A df
#' @source {created with pbmc3k data}
#' @examples
#' data(ce)       #Lazy loading. Data becomes visible as soon as called
"ce"

#' pbmc3k matrix
#'
#' @format A matrix
#' @source {created with pbmc3k data}
#' @examples
#' data(pbmc.mtx)       #Lazy loading. Data becomes visible as soon as called
"pbmc.mtx"

#' pbmc3k meta
#'
#' @format A df
#' @source {created with pbmc3k data}
#' @examples
#' data(pbmc.meta)       #Lazy loading. Data becomes visible as soon as called
"pbmc.meta"

#' mouse brain coords
#'
#' @format A df
#' @source {created with brain data}
#' @examples
#' data(coords.df)       #Lazy loading. Data becomes visible as soon as called
"coords.df"

#' mouse brain gene set activities
#'
#' @format A df
#' @source {created with brain data}
#' @examples
#' data(weight_df)       #Lazy loading. Data becomes visible as soon as called
"weight_df"


