% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifftshift.R
\name{ifftshift}
\alias{ifftshift}
\title{Inverse zero-frequency shift}
\usage{
ifftshift(x, MARGIN = 2)
}
\arguments{
\item{x}{input data, specified as a vector or matrix.}

\item{MARGIN}{dimension to operate along, 1 = row, 2 = columns (default).
Specifying \code{MARGIN = c(1, 2)} centers along both rows and columns.
Ignored when \code{x} is a vector.}
}
\value{
back-transformed vector or matrix.
}
\description{
Rearranges a zero-frequency-shifted Fourier transform back to the original.
}
\details{
Undo the action of the fftshift function. For even length \code{x},
\code{fftshift} is its own inverse, but not for odd length input.
}
\examples{
Xeven <- 1:6
res <- fftshift(fftshift(Xeven))

Xodd <- 1:7
res <- fftshift(fftshift(Xodd))
res <- ifftshift(fftshift(Xodd))

}
\seealso{
\code{\link{fftshift}}
}
\author{
Vincent Cautaerts, \email{vincent@comf5.comm.eng.osaka-u.ac.jp},\cr
  adapted by John W. Eaton.\cr
  Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
