% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hanning.R
\name{hann}
\alias{hann}
\alias{hanning}
\title{Hann window}
\usage{
hann(n, method = c("symmetric", "periodic"))

hanning(n, method = c("symmetric", "periodic"))
}
\arguments{
\item{n}{Window length, specified as a positive integer.}

\item{method}{Character string. Window sampling method, specified as:
\describe{
  \item{"symmetric"}{(Default). Use this option when using windows for filter
  design.}
  \item{"periodic"}{This option is useful for spectral analysis because it
  enables a windowed signal to have the perfect periodic extension implicit
  in the discrete Fourier transform. When \code{"periodic"} is specified, the
  function computes a window of length \code{n + 1} and returns the first
  \code{n} points.}
}}
}
\value{
Hann window, returned as a vector.
}
\description{
Return the filter coefficients of a Hann window of length \code{n}.
}
\details{
The Hann window is a member of the family of cosine sum windows. It was named
after Julius von Hann, and is sometimes referred to as Hanning, presumably
due to its linguistic and formulaic similarities to Hamming window.
}
\examples{

h <- hann(64)
plot (h, type = "l", xlab = "Samples", ylab =" Amplitude")

hs = hann(64,'symmetric')
hp = hann(63,'periodic')
plot (hs, type = "l", xlab = "Samples", ylab =" Amplitude")
lines(hp, col="red")

}
\author{
Andreas Weingessel, \email{Andreas.Weingessel@ci.tuwien.ac.at}.\cr
Conversion to R by Geert van Boxtel \email{G.J.M.vanBoxtel@gmail.com}.
}
