% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rssq.R
\name{rssq}
\alias{rssq}
\title{Root-sum-of-squares}
\usage{
rssq(x, MARGIN = 2)
}
\arguments{
\item{x}{the data, expected to be a vector, a matrix, an array.}

\item{MARGIN}{a vector giving the subscripts which the function will be
applied over. E.g., for a matrix 1 indicates rows, 2 indicates columns,
c(1, 2) indicates rows and columns. Where \code{x} has named dimnames, it
can be a character vector selecting dimension names. Default: 2 (usually
columns)}
}
\value{
Vector or array of values containing the root-sum-of-squares of the
  specified \code{MARGIN} of \code{x}.
}
\description{
Compute the root-sum-of-squares (SSQ) of the object \code{x}.
}
\details{
The input \code{x} can be a vector, a matrix or an array. If the input is a
vector, a single value is returned representing the root-sum-of-squares of
the vector. If the input is a matrix or an array, a vector or an array of
values is returned representing the root-sum-of-squares of the dimensions of
\code{x} indicated by the \code{MARGIN} argument.

Support for complex valued input is provided. The sum of squares of complex
numbers is defined by \code{sum(x * Conj(x))}
}
\examples{
## numeric vector
x <- c(1:5)
p <- rssq(x)

## numeric matrix
x <- matrix(c(1,2,3, 100, 150, 200, 1000, 1500, 2000), 3, 3)
p <- rssq(x)
p <- rssq(x, 1)

## numeric array
x <- array(c(1, 1.5, 2, 100, 150, 200, 1000, 1500,
            2000, 10000, 15000, 20000), c(2,3,2))
p <- rssq(x, 1)
p <- rssq(x, 2)
p <- rssq(x, 3)

## complex input
x <- c(1+1i, 2+3i, 3+5i, 4+7i, 5+9i)
p <- rssq(x)

}
\author{
Mike Miller.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
