% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsamplefill.R
\name{upsamplefill}
\alias{upsamplefill}
\title{Upsample and Fill}
\usage{
upsamplefill(x, v, copy = FALSE)
}
\arguments{
\item{x}{input data, specified as a numeric vector or matrix. In case of a
vector it represents a single signal; in case of a matrix each column is a
signal.}

\item{v}{vector of values to be placed between the elements of \code{x}.}

\item{copy}{logical. If TRUE then \code{v} should be a scalar
(\code{length(v) == 1)} and each value in \code{x} are repeated \code{v}
times. If FALSE (default), the values in the vector \code{v} are placed
between the elements of \code{x}.}
}
\value{
upsampled vector or matrix
}
\description{
Upsample and fill with given values or copies of the vector elements.
}
\examples{
u <- upsamplefill(diag(2), 2, TRUE)
u <- upsamplefill(diag(2), rep(-1, 3))

}
\seealso{
\code{\link{upsample}}
}
\author{
Juan Pablo Carbajal, \email{carbajal@ifi.uzh.ch}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
