% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conv2.R
\name{conv2}
\alias{conv2}
\title{2-D convolution}
\usage{
conv2(a, b, shape = c("full", "same", "valid"))
}
\arguments{
\item{a, b}{Input matrices, coerced to numeric.}

\item{shape}{Subsection of convolution, partially matched to:
\describe{
  \item{"full"}{Return the full convolution (default)}
  \item{"same"}{Return the central part of the convolution with the same size
  as A. The central part of the convolution begins at the indices
  \code{floor(c(nrow(b), ncol(b)) / 2 + 1)}}
  \item{"valid"}{Return only the parts which do not include zero-padded
  edges. The size of the result is \code{max(nrow(a) - nrow(a) + 1, 0)} by
  \code{max(ncol(A) - ncol(B) + 1, 0)}}
}}
}
\value{
Convolution of input matrices, returned as a matrix.
}
\description{
Compute the two-dimensional convolution of two matrices.
}
\examples{
a <- matrix(1:16, 4, 4)
b <- matrix(1:9, 3,3)
cnv <- conv2(a, b)
cnv <- conv2(a, b, "same")
cnv <- conv2(a, b, "valid")

}
\seealso{
\code{\link{conv}}, \code{\link[stats]{convolve}}
}
\author{
Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
